# Tcl3D - Doing 3D with Tcl #

Tcl3D offers the 3D functionality of OpenGL and other 3D libraries
at the Tcl scripting level.
This is accomplished by wrapping the libraries with the help of SWIG.

The Tcl3D package consists of the following building blocks:  

## Tcl3D basic modules: ##

* `tcl3dOgl`    Enhanced Togl widget, a Tk widget for OpenGL content.
                Wrapper for OpenGL functionality based on the GLEW library.
                Utility library (math, shapes, stop watch, ..).
* `tcl3dGauges` A pure Tcl package for displaying gauges.
* `tcl3dGl2ps`  Wrapper for the OpenGL To Postscript library.

## Tcl3D optional modules: ##

* `tcl3dFTGL` Wrapper for the OpenGL Font Rendering Library.
* `tcl3dOsg`  Wrapper for the OpenSceneGraph library.
* `tcl3dSDL`  Wrapper for the Simple DirectMedia Library.

Tcl3D contains lots of demonstration programs.

Tcl3D sources and demos are available at https://www.tcl3d.org/.
For a detailed description of Tcl3D and it's installation,
see chapter 1 of the Tcl3D manual.

The Tcl3D wrapper source code is copyrighted by Paul Obermeier
and distributed under the 3-clause BSD license.
The wrapped libraries may have differing licensing conditions, see
https://www.tcl3d.org/documentation.html#modules for details.

Please send questions, bug reports or any other feedback about Tcl3D to 
<info@tcl3d.org> or visit the Tcl3D related pages on the Wiki:

* https://wiki.tcl-lang.org/page/Tcl3D (Tcl3D)
* https://wiki.tcl-lang.org/page/Tcl3D+Discussion (Tcl3D Discussion)
