puts "Start createExtUrlList.tcl"

set inFile  "GLSpec/glExtUrlList.html"
set outFile "GLSpec/glExtUrlList.txt"

set inFp  [open $inFile  "r"]
set outFp [open $outFile "w"]

puts "  Reading $inFile ..."
set numExts 0
while { [gets $inFp line] >= 0 } {
    set indRef [string first "a href" $line]
    if { $indRef >= 0 } {
        set indUrlStart [string first "=" $line $indRef]
        set indUrlStop  [string first ">" $line $indRef]
        set indNameStop [string first "<" $line $indRef]
        set url [string range $line [expr $indUrlStart +1] [expr $indUrlStop -1]]
        set url [string trim $url "\""]
        set extName [string range $line [expr $indUrlStop +1] [expr $indNameStop -1]]
        puts $outFp "$extName $url"
        incr numExts
    }
}
puts "  Found $numExts extensions"
puts "  Writing $outFile ..."

close $inFp
close $outFp

puts "Done createExtUrlList.tcl"
exit 0
