/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgDB.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module osgDB.
 *
 *****************************************************************************/

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgDBHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{
using namespace osg;
using namespace osgDB;
%}

%ignore osgDB::ReaderWriter::Options;
%ignore osgDB::ReaderWriter::ReadResult;
%ignore osgDB::ReaderWriter::WriteResult;

%ignore osgDB::ReaderWriter::openArchive;
%ignore osgDB::ReaderWriter::readObject;
%ignore osgDB::ReaderWriter::readImage;
%ignore osgDB::ReaderWriter::readHeightField;
%ignore osgDB::ReaderWriter::readNode;
%ignore osgDB::ReaderWriter::readShader;
%ignore osgDB::ReaderWriter::writeObject;
%ignore osgDB::ReaderWriter::writeImage;
%ignore osgDB::ReaderWriter::writeHeightField;
%ignore osgDB::ReaderWriter::writeNode;
%ignore osgDB::ReaderWriter::writeShader;

%include osgDB/ReaderWriter
%include osgDB/ReadFile
%include osgDB/WriteFile
%include osgDB/Version
