/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgHeader.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file supplies the header files for OSG module osg.
 *
 *****************************************************************************/

%{
#include <string>
#include <sstream>
#include <vector>
#include <map>

/* Include this file first, because it defines macro OPENSCENEGRAPH_SOVERSION,
 * which is used throughout the wrapper interface files to determine the
 * OSG version used. See tcl3dOsg's Makefile for a mapping of SOVERSIONS to
 * OpenSceneGraph readable versions (i.e. 2.2, 2.4, ...).
 * The Tcl3D wrapper starts with SOVERSION 55, i.e. OSG 2.8.0 and up.
 */
#include <osg/Version>

/* Include this OSG file next, because it defines whether floats or doubles
 * are used for matrices, planes and bounding volumes.
 */
#include <osg/Config>

/* The rest of the OSG header files are included in alphabetical order for
 * ease of inspection.
 */
#include <osg/AlphaFunc>
#include <osg/AnimationPath>
#include <osg/ApplicationUsage>
#include <osg/ArgumentParser>
#include <osg/Array>
#include <osg/AutoTransform>
#include <osg/Billboard>
#include <osg/BlendColor>
#include <osg/BlendEquation>
#include <osg/BlendFunc>
#include <osg/BoundingBox>
#include <osg/BoundingSphere>
#include <osg/BoundsChecking>
#include <osg/buffered_value>
#include <osg/BufferObject>
#include <osg/Camera>
#include <osg/CameraView>
#include <osg/ClampColor>
#include <osg/ClearNode>
#include <osg/ClipNode>
#include <osg/ClipPlane>
#include <osg/ClusterCullingCallback>
#include <osg/CollectOccludersVisitor>
#include <osg/ColorMask>
#include <osg/ColorMatrix>
#include <osg/ComputeBoundsVisitor>
#include <osg/ConvexPlanarOccluder>
#include <osg/ConvexPlanarPolygon>
#include <osg/CoordinateSystemNode>
#include <osg/CopyOp>
#include <osg/CullFace>
#include <osg/CullingSet>
#include <osg/CullSettings>
#include <osg/CullStack>
#include <osg/DeleteHandler>
#include <osg/Depth>
#include <osg/DisplaySettings>
#include <osg/Drawable>
#include <osg/DrawPixels>
#include <osg/Endian>
#include <osg/Export>
#include <osg/fast_back_stack>
#include <osg/Fog>
#include <osg/FragmentProgram>
#include <osg/FrameBufferObject>
#include <osg/FrameStamp>
#include <osg/FrontFace>
#include <osg/Geode>
#include <osg/Geometry>
#include <osg/GL>
#include <osg/GL2Extensions>
#include <osg/GLExtensions>
#include <osg/GLObjects>
#include <osg/GLU>
#include <osg/GraphicsContext>
#include <osg/GraphicsThread>
#include <osg/Group>
#include <osg/Hint>
#include <osg/Image>
#include <osg/ImageStream>
#include <osg/io_utils>
#include <osg/Light>
#include <osg/LightModel>
#include <osg/LightSource>
#include <osg/LineSegment>
#include <osg/LineStipple>
#include <osg/LineWidth>
#include <osg/LOD>
#include <osg/LogicOp>
#include <osg/Material>
#include <osg/Math>
#include <osg/Matrix>
#include <osg/Matrixd>
#include <osg/Matrixf>
#include <osg/MatrixTransform>
#include <osg/MixinVector>
#include <osg/Multisample>
#include <osg/Node>
#include <osg/Callback>
#include <osg/NodeTrackerCallback>
#include <osg/NodeVisitor>
#include <osg/Notify>
#include <osg/Object>
#include <osg/Observer>
#include <osg/observer_ptr>
#include <osg/OccluderNode>
#include <osg/OcclusionQueryNode>
#include <osg/OperationThread>
#include <osg/PagedLOD>
#include <osg/Plane>
#include <osg/Point>
#include <osg/PointSprite>
#include <osg/PolygonMode>
#include <osg/PolygonOffset>
#include <osg/PolygonStipple>
#include <osg/Polytope>
#include <osg/PositionAttitudeTransform>
#include <osg/PrimitiveSet>
#include <osg/Program>
#include <osg/Projection>
#include <osg/ProxyNode>
#include <osg/Quat>
#include <osg/Referenced>
#include <osg/ref_ptr>
#include <osg/RenderInfo>
#include <osg/Scissor>
#include <osg/Sequence>
#include <osg/ShadeModel>
#include <osg/Shader>
#include <osg/ShadowVolumeOccluder>
#include <osg/Shape>
#include <osg/ShapeDrawable>
#include <osg/State>
#include <osg/StateAttribute>
#include <osg/StateSet>
#include <osg/Stats>
#include <osg/Stencil>
#include <osg/StencilTwoSided>
#include <osg/Switch>
#include <osg/TemplatePrimitiveFunctor>
#include <osg/TexEnv>
#include <osg/TexEnvCombine>
#include <osg/TexEnvFilter>
#include <osg/TexGen>
#include <osg/TexGenNode>
#include <osg/TexMat>
#include <osg/Texture>
#include <osg/Texture1D>
#include <osg/Texture2D>
#include <osg/Texture2DArray>
#include <osg/Texture3D>
#include <osg/TextureCubeMap>
#include <osg/TextureRectangle>
#include <osg/Timer>
#include <osg/TransferFunction>
#include <osg/Transform>
#include <osg/TriangleFunctor>
#include <osg/TriangleIndexFunctor>
#include <osg/Uniform>
#include <osg/Vec2>
#include <osg/Vec2b>
#include <osg/Vec2d>
#include <osg/Vec2f>
#include <osg/Vec2s>
#include <osg/Vec3>
#include <osg/Vec3b>
#include <osg/Vec3d>
#include <osg/Vec3f>
#include <osg/Vec3s>
#include <osg/Vec4>
#include <osg/Vec4b>
#include <osg/Vec4d>
#include <osg/Vec4f>
#include <osg/Vec4s>
#include <osg/Vec4ub>
#include <osg/VertexProgram>
#include <osg/View>
#include <osg/Viewport>

%}

%define OSG_EXPORT
%enddef
%define OSGANIMATION_EXPORT
%enddef
%define OSGDB_EXPORT
%enddef
%define OSGFX_EXPORT
%enddef
%define OSGGA_EXPORT
%enddef
%define OSGMANIPULATOR_EXPORT
%enddef
%define OSGPARTICLE_EXPORT
%enddef
%define OSGSHADOW_EXPORT
%enddef
%define OSGSIM_EXPORT
%enddef
%define OSGTERRAIN_EXPORT
%enddef
%define OSGTEXT_EXPORT
%enddef
%define OSGUTIL_EXPORT
%enddef
%define OSGVIEWER_EXPORT
%enddef
%define OSGVOLUME_EXPORT
%enddef
