/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgSim.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module osgSim.
 *
 *****************************************************************************/

%include "tcl3dSwigDefines.i"

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{

using namespace osg;
using namespace osgSim;

%}

%ignore osgSim::SphereSegment::computeIntersection;

// Method available in const and non-const version: SWIG shadowing warning.
%ignore osgSim::GeographicLocation::latitude();
%ignore osgSim::GeographicLocation::longitude();

// Ignoring the friend operator did not work. So we just rename it and SWIG
// does not complain about it.
// Method with std::streams typically not useful from the Tcl level. Just get
// the lat/lon coordinates and print them with Tcl commands.
%rename(friendStreamOut) operator<<(std::ostream& output, const GeographicLocation& loc);

%OPERATOR_RENAME(osgSim::GeographicLocation)

%rename(get) osgSim::Sector::operator ();

%include osgSim/ScalarsToColors

%include osgSim/BlinkSequence
%include osgSim/ColorRange
%include osgSim/DOFTransform
%include osgSim/ElevationSlice
%include osgSim/GeographicLocation
%include osgSim/HeightAboveTerrain
%include osgSim/Impostor
%include osgSim/ImpostorSprite
%include osgSim/InsertImpostorsVisitor
%include osgSim/LightPoint
%include osgSim/LightPointNode
%include osgSim/LightPointSystem
%include osgSim/LineOfSight
%include osgSim/MultiSwitch
%include osgSim/ObjectRecordData
%include osgSim/OverlayNode
// TODO One of the constructors in ScalarBar upsets SWIG, so that it
// cannot parse the header file.
// %include osgSim/ScalarBar
%include osgSim/Sector
%include osgSim/SphereSegment
%include osgSim/Version
%include osgSim/VisibilityGroup
