/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgTerrain.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgTerrain.
 *
 *****************************************************************************/

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTerrainHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{
using namespace osg;
using namespace osgTerrain;
%}

%rename(get) osgTerrain::ValidDataOperator::operator ();

%include osgTerrain/TerrainTechnique
%include osgTerrain/GeometryTechnique

%include osgTerrain/Layer
%include osgTerrain/Locator
%include osgTerrain/Terrain
%ignore osgTerrain::TerrainTile::setTileLoadedCallback;
%ignore osgTerrain::TerrainTile::getTileLoadedCallback;
%include osgTerrain/TerrainTile
%include osgTerrain/ValidDataOperator

%include osgTerrain/Version
