/******************************************************************************
 *{@C
 *      Copyright:      2009-2025 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       tcl3dSwigDefines.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file supports Swig macros used in the different
 *                      OSG wrapper files.
 *
 *****************************************************************************/

// Define SWIG macro to rename standard operators (*, /, *=, ...) 
// to standard method names (mul, div, mulSelf, ...).

%define %OPERATOR_RENAME(NAME)
%extend NAME {
    %rename(eq)   operator ==;
    %rename(ne)   operator !=;
    %rename(less) operator <;

    %rename(mul) operator *;
    %rename(div) operator /;
    %rename(add) operator +;
    %rename(sub) operator -;

    %rename(mulSelf) operator *=;
    %rename(divSelf) operator /=;
    %rename(addSelf) operator +=;
    %rename(subSelf) operator -=;
}
%enddef
