#******************************************************************************
#
#       Copyright:      2007-2025 Paul Obermeier (obermeier@tcl3d.org)
#
#                       See the file "Tcl3D_License.txt" for information on
#                       usage and redistribution of this file, and for a
#                       DISCLAIMER OF ALL WARRANTIES.
#
#       Module:         Tcl3D -> tcl3dSDL
#       Filename:       tcl3dSDLQuery.tcl
#
#       Author:         Paul Obermeier
#
#       Description:    Tcl module with query procedures related to
#                       the SDL module.
#
#******************************************************************************

###############################################################################
#[@e
#       Name:           tcl3dSDLGetVersion - Get SDL version string.
#
#       Synopsis:       tcl3dSDLGetVersion {}
#
#       Description:    Return the version string of the wrapped SDL library.
#                       The version is returned as "Major.Minor.Patch".
#
#       See also:       tcl3dOglGetVersions
#                       tcl3dGetLibraryInfo
#
###############################################################################

proc tcl3dSDLGetVersion {} {
    if { [info exists ::SDL_MAJOR_VERSION] } {
        return [format "%d.%d.%d" \
            $::SDL_MAJOR_VERSION \
            $::SDL_MINOR_VERSION \
            $::SDL_PATCHLEVEL]
    } else {
        return ""
    }
}

###############################################################################
#[@e
#       Name:           tcl3dSDLGetInfoString - Get environment info string.
#
#       Synopsis:       tcl3dSDLGetInfoString {}
#
#       Description:    Return a string containing information about the
#                       following environment values:
#                           Operating system
#                           SDL version
#                           Tk version
#                           Tcl/Tk bit size
#                       
#       See also:       tcl3dSDLGetVersion
#
###############################################################################

proc tcl3dSDLGetInfoString {} {
    return [format "Using Tcl3D %s on %s %s (SDL %s, Tk %s %d-bit)" \
           [package versions tcl3d] \
           $::tcl_platform(os) $::tcl_platform(osVersion) \
           [tcl3dSDLGetVersion] $::tk_patchLevel \
           [expr $::tcl_platform(pointerSize) == 4? 32: 64]]
}
