/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         FileFormats
 *      Filename:       FF_ImageRaw.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Functions for reading and writing image files in
 *                      a simple raw file format.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __FF_IMAGERAW_H__
#define __FF_IMAGERAW_H__

#include "UT_Compat.h"
#include "FF_Image.h"

/* Functions for reading and writing RAW image files */

extern UT_Bool FF_ImgOpenWriteRaw (const char *, FF_ImgFileDesc *, const char *opts);
extern UT_Bool FF_ImgOpenReadRaw  (const char *, FF_ImgFileDesc *, const char *opts);

#endif /* __FF_IMAGERAW_H__ */
