/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         FileFormats
 *      Filename:       FF_ImageSgiLib.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Original "image.h" file as supplied by SGI, slightly
 *                      modified for usage in poSoft's library.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __FF_IMAGESGILIB_H__
#define __FF_IMAGESGILIB_H__

#ifndef __GL_IMAGE_H__
#define __GL_IMAGE_H__
#ifdef __cplusplus
extern "C" {
#endif


/*
 *      Defines for image files . . . .
 *
 *                      Paul Haeberli - 1984
 *      Look in /usr/people/4Dgifts/iristools/imgtools for example code!
 *
 */

#include <stdio.h>

#define IMAGIC  0732

/* colormap of images */
#define CM_NORMAL               0       /* file contains rows of values which 
                                         * are either RGB values (zsize == 3) 
                                         * or greyramp values (zsize == 1) */
#define CM_DITHERED             1
#define CM_SCREEN               2       /* file contains data which is a screen
                                         * image; getrow returns buffer which 
                                         * can be displayed directly with 
                                         * writepixels */
#define CM_COLORMAP             3       /* a colormap file */

#define TYPEMASK                0xff00
#define BPPMASK                 0x00ff
#define ITYPE_VERBATIM          0x0000
#define ITYPE_RLE               0x0100
#define ISRLE(type)             (((type) & 0xff00) == ITYPE_RLE)
#define ISVERBATIM(type)        (((type) & 0xff00) == ITYPE_VERBATIM)
#define BPP(type)               ((type) & BPPMASK)
#define RLE(bpp)                (ITYPE_RLE | (bpp))
#define VERBATIM(bpp)           (ITYPE_VERBATIM | (bpp))
#define IBUFSIZE(pixels)        ((pixels+(pixels>>6))<<2)
#define RLE_NOP                 0x00

#define ierror(p)               (((p)->flags&_IOERR)!=0)
#define ifileno(p)              ((p)->file)
#define getpix(p)               (--(p)->cnt>=0 ? *(p)->ptr++ : ifilbuf(p))
#define putpix(p,x)             (--(p)->cnt>=0 \
                                    ? ((int)(*(p)->ptr++=(unsigned)(x))) \
                                    : iflsbuf(p,(unsigned)(x)))

typedef struct {
    unsigned short      imagic;         /* stuff saved on disk . . */
    unsigned short      type;
    unsigned short      dim;
    unsigned short      xsize;
    unsigned short      ysize;
    unsigned short      zsize;
    unsigned int        min;
    unsigned int        max;
    unsigned int        wastebytes;     
    char                name[80];
    unsigned int        colormap;

    FILE *              file;           /* stuff used in core only */
    unsigned short      flags;
    short               dorev;
    short               x;
    short               y;
    short               z;
    short               cnt;
    unsigned short      *ptr;
    unsigned short      *base;
    unsigned short      *tmpbuf;
    unsigned int        offset;
    unsigned int        rleend;         /* for rle images */
    unsigned int        *rowstart;      /* for rle images */
    int                 *rowsize;       /* for rle images */
} IMAGE;

extern IMAGE *sgiOpen (const char *file, const char *mode, unsigned int type, unsigned int dim,
                       unsigned int xsize, unsigned int ysize, unsigned int zsize );
extern int sgiClose (IMAGE *image);
extern int sgiPutrow (IMAGE *image, unsigned short *buffer,
                   unsigned int y, unsigned int z);
extern int sgiGetrow (IMAGE *image, unsigned short *buffer,
                   unsigned int y, unsigned int z);

#define IMAGEDEF                /* for backwards compatibility */
#ifdef __cplusplus
}
#endif
#endif  /* !__GL_IMAGE_H__ */

#endif /* __FF_IMAGESGILIB_H__ */
