/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Image Processing
 *      Filename:       IPT_Private.h
 *
 *      Author:         Paul Obermeier
 *
 *      Usage:          Declaration of the Tcl wrapper functions for the
 *                      image processing library.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __IPT_PRIVATE_H__
#define __IPT_PRIVATE_H__

#include "UT_Compat.h"

#define Tmpsize 1024

extern FF_ImgFmtType   IPT_StateFormatDefault[FF_NumImgChanTypes];
extern UT_Bool         IPT_StateDrawMaskDefault[FF_NumImgChanTypes];
extern Float32         IPT_StateDrawColorDefault[FF_NumImgChanTypes];
extern IP_DrawModeType IPT_StateDrawModeDefault[FF_NumImgChanTypes];

extern UT_Bool IPT_HasPhotoSupport (TCLPARAMLIST);

extern UT_Bool IPT_GetChannelFormat   (TCLPARAMLIST);
extern UT_Bool IPT_GetChannelType     (TCLPARAMLIST);
extern UT_Bool IPT_GetDrawModeType    (TCLPARAMLIST);
extern UT_Bool IPT_GetFillModeType    (TCLPARAMLIST);
extern UT_Bool IPT_GetUnlaceModeType  (TCLPARAMLIST);

extern UT_Bool IPT_GetChannelFormatName   (TCLPARAMLIST);
extern UT_Bool IPT_GetChannelTypeName     (TCLPARAMLIST);
extern UT_Bool IPT_GetDrawModeTypeName    (TCLPARAMLIST);
extern UT_Bool IPT_GetFillModeTypeName    (TCLPARAMLIST);
extern UT_Bool IPT_GetUnlaceModeTypeName  (TCLPARAMLIST);

extern UT_Bool IPT_SetFormat       (TCLPARAMLIST);
extern UT_Bool IPT_GetFormat       (TCLPARAMLIST);
extern UT_Bool IPT_SetDrawMask     (TCLPARAMLIST);
extern UT_Bool IPT_GetDrawMask     (TCLPARAMLIST);
extern UT_Bool IPT_SetDrawColor    (TCLPARAMLIST);
extern UT_Bool IPT_GetDrawColor    (TCLPARAMLIST);
extern UT_Bool IPT_SetDrawMode     (TCLPARAMLIST);
extern UT_Bool IPT_GetDrawMode     (TCLPARAMLIST);
extern UT_Bool IPT_SetColorCorrect (TCLPARAMLIST);
extern UT_Bool IPT_GetColorCorrect (TCLPARAMLIST);
extern UT_Bool IPT_PushState       (TCLPARAMLIST);
extern UT_Bool IPT_PopState        (TCLPARAMLIST);
extern UT_Bool IPT_SetNumThreads   (TCLPARAMLIST);
extern UT_Bool IPT_GetNumThreads   (TCLPARAMLIST);

extern UT_Bool IPT_GetTextSize  (TCLPARAMLIST);
extern UT_Bool IPT_GetTextScale (TCLPARAMLIST);
extern UT_Bool IPT_SetTextScale (TCLPARAMLIST);

extern UT_Bool IPT_GetFileInfo   (TCLPARAMLIST);
extern UT_Bool IPT_GetFileFormat (TCLPARAMLIST);

extern UT_Bool IPT_MemCheck (TCLPARAMLIST);

extern UT_Bool IPT_NewImage          (OBJPARAMLIST);
extern UT_Bool IPT_NewImageFromFile  (OBJPARAMLIST);
extern UT_Bool IPT_NewImageFromPhoto (OBJPARAMLIST);

extern UT_Bool IPT_AddChannel    (ELEMPARAMLIST);
extern UT_Bool IPT_DeleteChannel (ELEMPARAMLIST);

extern UT_Bool IPT_HasChannel     (ELEMPARAMLIST);
extern UT_Bool IPT_GetImageInfo   (ELEMPARAMLIST);
extern UT_Bool IPT_GetImageFormat (ELEMPARAMLIST);

extern UT_Bool IPT_ReadImage   (ELEMPARAMLIST);
extern UT_Bool IPT_WriteImage  (ELEMPARAMLIST);
extern UT_Bool IPT_WriteSimple (ELEMPARAMLIST);

extern UT_Bool IPT_DrawPixel     (ELEMPARAMLIST);
extern UT_Bool IPT_DrawLine      (ELEMPARAMLIST);
extern UT_Bool IPT_DrawRect      (ELEMPARAMLIST);
extern UT_Bool IPT_DrawEllipse   (ELEMPARAMLIST);
extern UT_Bool IPT_DrawCircle    (ELEMPARAMLIST);
extern UT_Bool IPT_DrawBrushLine (ELEMPARAMLIST);
extern UT_Bool IPT_DrawBrush     (ELEMPARAMLIST);
extern UT_Bool IPT_MergeBrush    (ELEMPARAMLIST);
extern UT_Bool IPT_DrawText      (ELEMPARAMLIST);
extern UT_Bool IPT_Blank         (ELEMPARAMLIST);
extern UT_Bool IPT_BlankRect     (ELEMPARAMLIST);
extern UT_Bool IPT_CopyRect      (ELEMPARAMLIST);
extern UT_Bool IPT_WrapRect      (ELEMPARAMLIST);
extern UT_Bool IPT_CopyChannel   (ELEMPARAMLIST);
extern UT_Bool IPT_CopyImage     (ELEMPARAMLIST);

extern UT_Bool IPT_DrawAAPixel (ELEMPARAMLIST);
extern UT_Bool IPT_DrawAALine  (ELEMPARAMLIST);
extern UT_Bool IPT_DrawAAText  (ELEMPARAMLIST);

extern UT_Bool IPT_CompositeMatte      (ELEMPARAMLIST);
extern UT_Bool IPT_CompositeColorMatte (ELEMPARAMLIST);
extern UT_Bool IPT_CompositeDepth      (ELEMPARAMLIST);
extern UT_Bool IPT_CrossDissolve       (ELEMPARAMLIST);

extern UT_Bool IPT_Interlace (ELEMPARAMLIST);
extern UT_Bool IPT_Unlace    (ELEMPARAMLIST);

extern UT_Bool IPT_WarpKeypoint  (ELEMPARAMLIST);
extern UT_Bool IPT_BlendKeypoint (ELEMPARAMLIST);
extern UT_Bool IPT_WarpFunct     (ELEMPARAMLIST);
extern UT_Bool IPT_BlendFunct    (ELEMPARAMLIST);

extern UT_Bool IPT_ChangeChannelGamma      (ELEMPARAMLIST);
extern UT_Bool IPT_RemapChannelValues      (ELEMPARAMLIST);
extern UT_Bool IPT_Blur                    (ELEMPARAMLIST);
extern UT_Bool IPT_DepthBlur               (ELEMPARAMLIST);
extern UT_Bool IPT_ComputeChannelDerivates (ELEMPARAMLIST);
extern UT_Bool IPT_Median                  (ELEMPARAMLIST);
extern UT_Bool IPT_MedianSequence          (ELEMPARAMLIST);
extern UT_Bool IPT_Dilatation              (ELEMPARAMLIST);
extern UT_Bool IPT_Erosion                 (ELEMPARAMLIST);
extern UT_Bool IPT_Flicker                 (ELEMPARAMLIST);
extern UT_Bool IPT_CutOff                  (ELEMPARAMLIST);
extern UT_Bool IPT_Threshold               (ELEMPARAMLIST);
extern UT_Bool IPT_MarkNonZeroPixels       (ELEMPARAMLIST);
extern UT_Bool IPT_DifferenceImage         (ELEMPARAMLIST);

extern UT_Bool IPT_FlipDiagonal   (ELEMPARAMLIST);
extern UT_Bool IPT_FlipHorizontal (ELEMPARAMLIST);
extern UT_Bool IPT_FlipVertical   (ELEMPARAMLIST);
extern UT_Bool IPT_Rotate90       (ELEMPARAMLIST);

extern UT_Bool IPT_ScaleRect (ELEMPARAMLIST);

extern UT_Bool IPT_CreateChannelNoise (ELEMPARAMLIST);
extern UT_Bool IPT_JuliaSet   (ELEMPARAMLIST);
extern UT_Bool IPT_Mandelbrot (ELEMPARAMLIST);

extern UT_Bool IPT_GetChannelHistogram (ELEMPARAMLIST);
extern UT_Bool IPT_GetChannelStats     (ELEMPARAMLIST);
extern UT_Bool IPT_GetChannelRange     (ELEMPARAMLIST);
extern UT_Bool IPT_DiffChannel         (ELEMPARAMLIST);

extern UT_Bool IPT_CorrelateChannel   (ELEMPARAMLIST);
extern UT_Bool IPT_FindChannelPattern (ELEMPARAMLIST);

extern UT_Bool IPT_GetSample (ELEMPARAMLIST);
extern UT_Bool IPT_GetPixel  (ELEMPARAMLIST);

extern UT_Bool IPT_ShearVertical   (ELEMPARAMLIST);
extern UT_Bool IPT_ShearHorizontal (ELEMPARAMLIST);

extern UT_Bool IPT_Stamp (ELEMPARAMLIST);

extern UT_Bool IPT_AsPhoto     (ELEMPARAMLIST);
extern UT_Bool IPT_AsByteArray (ELEMPARAMLIST);

#endif /* __IPT_PRIVATE_H__ */
