/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         ImageProcessing
 *      Filename:       IPT_TclIf.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declaration of the functions exported by the Tcl
 *                      Image Processing library.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __IPT_TCLIF_H__
#define __IPT_TCLIF_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <tcl.h>

#include "UT_Compat.h"
#include "IP_Image.h"

#include "UTT_TclIf.h"

/* See UTT_TclIf.h for the definition of the UTT_* macros. */

#define IPT_GetFixImage(n, var)                   \
    UTT_GetFixGeneric (IPT_GetImage, n, var)

#define IPT_GetOptImage(n, var, def)              \
    UTT_GetOptGeneric (IPT_GetImage, n, var, def)

#define IPT_GetFixFormatEnum(n, var)              \
    UTT_GetFixGeneric (IPT_GetFormatEnum, n, var)

#define IPT_GetOptFormatEnum(n, var, def)         \
    UTT_GetOptGeneric (IPT_GetFormatEnum, n, var, def)

#define IPT_GetFixChannelEnum(n, var)              \
    UTT_GetFixGeneric (IPT_GetChannelEnum, n, var)

#define IPT_GetOptChannelEnum(n, var, def)         \
    UTT_GetOptGeneric (IPT_GetChannelEnum, n, var, def)

#define IPT_GetFixDrawModeEnum(n, var)              \
    UTT_GetFixGeneric (IPT_GetDrawModeEnum, n, var)

#define IPT_GetOptDrawModeEnum(n, var, def)         \
    UTT_GetOptGeneric (IPT_GetDrawModeEnum, n, var, def)

#define IPT_GetFixFillModeEnum(n, var)              \
    UTT_GetFixGeneric (IPT_GetFillModeEnum, n, var)

#define IPT_GetOptFillModeEnum(n, var, def)         \
    UTT_GetOptGeneric (IPT_GetFillModeEnum, n, var, def)

#define IPT_GetFixUnlaceModeEnum(n, var)              \
    UTT_GetFixGeneric (IPT_GetUnlaceModeEnum, n, var)

#define IPT_GetOptUnlaceModeEnum(n, var, def)         \
    UTT_GetOptGeneric (IPT_GetUnlaceModeEnum, n, var, def)

extern POIMG_IMPORT_EXPORT int IPT_InitTclImgLib (Tcl_Interp *interp);

extern POIMG_IMPORT_EXPORT UT_Bool IPT_CreateTclCmd (Tcl_Interp *interp, IP_ImageId img);

extern POIMG_IMPORT_EXPORT int IPT_GetImage      (Tcl_Interp *interp, const char *varValue, IP_ImageId *img);

extern POIMG_IMPORT_EXPORT int IPT_GetFormatEnum      (Tcl_Interp *interp, const char *varValue, FF_ImgFmtType *fmt);
extern POIMG_IMPORT_EXPORT int IPT_GetChannelEnum     (Tcl_Interp *interp, const char *varValue, FF_ImgChanType *chan);
extern POIMG_IMPORT_EXPORT int IPT_GetDrawModeEnum    (Tcl_Interp *interp, const char *varValue, IP_DrawModeType *drawMode);
extern POIMG_IMPORT_EXPORT int IPT_GetFillModeEnum    (Tcl_Interp *interp, const char *varValue, IP_FillModeType *fillMode);
extern POIMG_IMPORT_EXPORT int IPT_GetUnlaceModeEnum  (Tcl_Interp *interp, const char *varValue, IP_UnlaceModeType *unlaceMode);

extern POIMG_IMPORT_EXPORT UT_Bool IP_AsPhoto (Tcl_Interp *interp, IP_ImageId img, const char *photoName,
                                               FF_ImgChanType chanMapList[4],
                                               Float32 gamma, Float32 minValue, Float32 maxValue);
extern POIMG_IMPORT_EXPORT IP_ImageId IP_NewImageFromPhoto (Tcl_Interp *interp, const char *photoName);

#ifdef __cplusplus
}
#endif

#endif /* __IPT_TCLIF_H__ */
