/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         ImageProcessing
 *      Filename:       IPT_TclPkg.c
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Initialization of Tcl stubs and the image
 *                      processing package.
 *
 *      Exported functions:
 *                      Poimg_Init
 *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "UT_Compat.h"

#if defined (WIN32)
    #include <windows.h>
#endif

#include <tcl.h>
#ifdef USE_TK_PHOTOS
#include <tk.h>
#endif

#include "UT_Error.h"
#include "UT_Vector.h"
#include "UT_Memory.h"

#include "UTT_TclIf.h"
#include "UTT_SwatchTclIf.h"
#include "UTT_VecTclIf.h"
#include "IPT_TclIf.h"

#include "../poImgUuid.h"

static int initMyLibs (Tcl_Interp *interp)
{
    if (UTT_InitTclLib (interp) == TCL_ERROR) {
        printf ("Error initializing TclLib\n");
        return TCL_ERROR;
    }

    if (UTT_InitTclSwatchLib (interp) == TCL_ERROR) {
        printf ("Error initializing TclSwatchLib\n");
        return TCL_ERROR;
    }

    if (UTT_InitTclVecLib (interp) == TCL_ERROR) {
        printf ("Error initializing TclVecLib\n");
        return TCL_ERROR;
    }

    if (IPT_InitTclImgLib (interp) == TCL_ERROR) {
        printf ("Error initializing TclImgLib\n");
        return TCL_ERROR;
    }

    return TCL_OK;
}

#undef  TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT

EXTERN int Poimg_Init (Tcl_Interp *interp)
{
    Tcl_CmdInfo info;

    if (Tcl_InitStubs (interp, "8.6-", 0) == NULL) {
        return TCL_ERROR;
    }

#ifdef USE_TK_PHOTOS
    if (Tk_InitStubs (interp, "8.6-", 0) == NULL) {
        return TCL_ERROR;
    }
#endif

    if (initMyLibs (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

    if (Tcl_GetCommandInfo(interp, "::tcl::build-info", &info)) {
        Tcl_CreateObjCommand(interp, "::poImg::build-info",
        info.objProc, (void *)(PACKAGE_VERSION
            "+" STRINGIFY(POIMG_VERSION_UUID)
#if defined(__clang__) && defined(__clang_major__)
            ".clang-" STRINGIFY(__clang_major__)
#if __clang_minor__ < 10
            "0"
#endif
            STRINGIFY(__clang_minor__)
#endif
#if defined(__cplusplus) && !defined(__OBJC__)
            ".cplusplus"
#endif
#ifndef NDEBUG
            ".debug"
#endif
#ifdef DEBUG_LOCAL
            ".debug-local"
#endif
#if !defined(__clang__) && !defined(__INTEL_COMPILER) && defined(__GNUC__)
            ".gcc-" STRINGIFY(__GNUC__)
#if __GNUC_MINOR__ < 10
            "0"
#endif
            STRINGIFY(__GNUC_MINOR__)
#endif
#ifdef __INTEL_COMPILER
            ".icc-" STRINGIFY(__INTEL_COMPILER)
#endif
#ifdef TCL_MEM_DEBUG
            ".memdebug"
#endif
#if defined(_MSC_VER)
            ".msvc-" STRINGIFY(_MSC_VER)
#endif
#ifdef USE_NMAKE
            ".nmake"
#endif
#ifndef TCL_CFG_OPTIMIZED
            ".no-optimize"
#endif
#ifdef __OBJC__
            ".objective-c"
#if defined(__cplusplus)
            "plusplus"
#endif
#endif
#ifdef TCL_CFG_PROFILED
            ".profile"
#endif
#ifdef PURIFY
            ".purify"
#endif
#ifdef STATIC_BUILD
            ".static"
#endif
        ), NULL);
    }
    return Tcl_PkgProvide (interp, PACKAGE_NAME, PACKAGE_VERSION);
}
