/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UTT_Private.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declaration of the Tcl wrapper functions for the
 *                      utilities library.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UTT_PRIVATE_H__
#define __UTT_PRIVATE_H__

#include "UT_Compat.h"
#include "UTT_TclIf.h"

extern UT_Bool UTT_TfmCopy2D            (TCLPARAMLIST);
extern UT_Bool UTT_TfmCopy3D            (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildIdent2D      (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildIdent3D      (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildTrans2D      (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildTrans3D      (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildRot2D        (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildRot3D        (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildScale2D      (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildScale3D      (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildRotArb3D     (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildRotArbLos3D  (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildLookAt3D     (TCLPARAMLIST);
extern UT_Bool UTT_TfmBuildLookAtVec3D  (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcat2D          (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcat3D          (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcatTrans2D     (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcatTrans3D     (TCLPARAMLIST);
extern UT_Bool UTT_TfmMultTrans3D       (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcatRot2D       (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcatRot3D       (TCLPARAMLIST);
extern UT_Bool UTT_TfmMultRot3D         (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcatScale2D     (TCLPARAMLIST);
extern UT_Bool UTT_TfmConcatScale3D     (TCLPARAMLIST);
extern UT_Bool UTT_TfmInvert2D          (TCLPARAMLIST);
extern UT_Bool UTT_TfmInvert3D          (TCLPARAMLIST);
extern UT_Bool UTT_TfmTranspose3D       (TCLPARAMLIST);
extern UT_Bool UTT_TfmCoord2D           (TCLPARAMLIST);
extern UT_Bool UTT_TfmCoord3D           (TCLPARAMLIST);
extern UT_Bool UTT_TfmInitCoord2D       (TCLPARAMLIST);
extern UT_Bool UTT_TfmInitCoord3D       (TCLPARAMLIST);
extern UT_Bool UTT_TfmApply2D           (TCLPARAMLIST);
extern UT_Bool UTT_TfmApply3D           (TCLPARAMLIST);
extern UT_Bool UTT_TfmApplyNormal3D     (TCLPARAMLIST);

extern UT_Bool UTT_VecAngle2D           (TCLPARAMLIST);
extern UT_Bool UTT_VecAngle3D           (TCLPARAMLIST);
extern UT_Bool UTT_VecDistPointLine2D   (TCLPARAMLIST);
extern UT_Bool UTT_VecDistPointLine3D   (TCLPARAMLIST);
extern UT_Bool UTT_VecPointInTria2D     (TCLPARAMLIST);
extern UT_Bool UTT_VecPointInTria3D     (TCLPARAMLIST);
extern UT_Bool UTT_VecIsectPlaneLine2D  (TCLPARAMLIST);
extern UT_Bool UTT_VecIsectPlaneLine3D  (TCLPARAMLIST);
extern UT_Bool UTT_VecDistLineLine3D    (TCLPARAMLIST);
extern UT_Bool UTT_VecIsectPlanePlane3D (TCLPARAMLIST);
extern UT_Bool UTT_VecCopy2D            (TCLPARAMLIST);
extern UT_Bool UTT_VecCopy3D            (TCLPARAMLIST);
extern UT_Bool UTT_VecAdd2D             (TCLPARAMLIST);
extern UT_Bool UTT_VecAdd3D             (TCLPARAMLIST);
extern UT_Bool UTT_VecSub2D             (TCLPARAMLIST);
extern UT_Bool UTT_VecSub3D             (TCLPARAMLIST);
extern UT_Bool UTT_VecScale2D           (TCLPARAMLIST);
extern UT_Bool UTT_VecScale3D           (TCLPARAMLIST);
extern UT_Bool UTT_VecCrossProd2D       (TCLPARAMLIST);
extern UT_Bool UTT_VecCrossProd3D       (TCLPARAMLIST);
extern UT_Bool UTT_VecDotProd2D         (TCLPARAMLIST);
extern UT_Bool UTT_VecDotProd3D         (TCLPARAMLIST);
extern UT_Bool UTT_VecLength2D          (TCLPARAMLIST);
extern UT_Bool UTT_VecLength3D          (TCLPARAMLIST);
extern UT_Bool UTT_VecDist2D            (TCLPARAMLIST);
extern UT_Bool UTT_VecDist3D            (TCLPARAMLIST);
extern UT_Bool UTT_VecUnit2D            (TCLPARAMLIST);
extern UT_Bool UTT_VecUnit3D            (TCLPARAMLIST);
extern UT_Bool UTT_VecLinComb2D         (TCLPARAMLIST);
extern UT_Bool UTT_VecLinComb3D         (TCLPARAMLIST);
extern UT_Bool UTT_VecReflect2D         (TCLPARAMLIST);
extern UT_Bool UTT_VecReflect3D         (TCLPARAMLIST);
extern UT_Bool UTT_VecDecompose2D       (TCLPARAMLIST);
extern UT_Bool UTT_VecDecompose3D       (TCLPARAMLIST);

#endif /* __UTT_PRIVATE_H__ */
