/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UTT_TclPkg.c
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Initialization of Tcl stubs and the utility
 *                      package.
 *
 *      Exported functions:
 *                      Poutil_Init
 *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "UT_Compat.h"

#if defined (WIN32)
    #include <windows.h>
#endif

#include <tcl.h>

#include "UT_Error.h"
#include "UT_Vector.h"
#include "UT_Memory.h"

#include "UTT_TclIf.h"
#include "UTT_SwatchTclIf.h"
#include "UTT_VecTclIf.h"

static int initMyLibs (Tcl_Interp *interp)
{
    if (UTT_InitTclLib (interp) == TCL_ERROR) {
        printf ("Error initializing TclLib\n");
        return TCL_ERROR;
    }

    if (UTT_InitTclSwatchLib (interp) == TCL_ERROR) {
        printf ("Error initializing TclSwatchLib\n");
        return TCL_ERROR;
    }

    if (UTT_InitTclVecLib (interp) == TCL_ERROR) {
        printf ("Error initializing TclVecLib\n");
        return TCL_ERROR;
    }

    return TCL_OK;
}

#undef  TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT

EXTERN int Poutil_Init (Tcl_Interp *interp)
{
    if (Tcl_InitStubs (interp, "8.1", 0) == NULL) {
        return TCL_ERROR;
    }

    if (initMyLibs (interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

    return Tcl_PkgProvide (interp, PACKAGE_NAME, PACKAGE_VERSION);
}
