/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Crypt.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declaration of the data encryption routines.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_CRYPT_H__
#define __UT_CRYPT_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Compat.h"

/* Status as returned by UT_CryptDecode. */

typedef enum {
    UT_CryptStatusOK,           /* Decryption was successful */
    UT_CryptStatusWrong         /* Key didn't fit */
} UT_CryptStatus;

/* Modes for uuencoding. */

typedef enum {
    UT_CryptModeStandard,       /* Standard uuencoding */
    UT_CryptModeBase64          /* Base64 uuencoding */
} UT_CryptMode;

extern POIMG_IMPORT_EXPORT void UT_CryptEncode (UInt8[8], UInt32, Int32, UInt8 *, UInt8 *);
extern POIMG_IMPORT_EXPORT UT_CryptStatus UT_CryptDecode (UInt8[8], UInt32, Int32, UInt8 *, UInt8 *);
extern POIMG_IMPORT_EXPORT Int32 UT_CryptUuEncode (Int32, UInt8 *, UInt8 *, UT_CryptMode);

#ifdef __cplusplus
}
#endif

#endif /* __UT_CRYPT_H__ */
