/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_ErrTexts.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    General and OS dependent error message texts.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

static const char * const UT_ErrTexts[] = {
    /*  0 */    "(No error occurred)",
    /*  1 */    "(Unknown error code)",
    /*  2 */    "Unexpected input",
    /*  3 */    "Unexpected end of file",
    /*  4 */    "File is not of type 'poFile'",
    /*  5 */    "Wrong 'poFile' type",
    /*  6 */    "File was written on an incompatible machine",
    /*  7 */    "Parameter is out of range",
    /*  8 */    "Invalid parameter value",
    /*  9 */    "Function is not supported",

#if defined (OS_IS_UNIX) || \
    defined (OS_IS_WIN32)

    /* 10 */    "Attempted access requires ownership or "
                "superuser privileges",
    /* 11 */    "Attempt to access a nonexistent file "
                "or directory",
    /* 12 */    "Attempt to access a nonexistent process",
    /* 13 */    "Interrupted system call",
    /* 14 */    "Physical I/O error",
    /* 15 */    "Device is in use or does not exist",
    /* 16 */    "Argument list is too long",
    /* 17 */    "Exec format error",
    /* 18 */    "File descriptor does not refer to "
                "an open file",
    /* 19 */    "No child process",
    /* 20 */    "Too many processes running",
    /* 21 */    "Not enough space",
    /* 22 */    "Permission was denied",
    /* 23 */    "Bad address",
    /* 24 */    "Block device required",
    /* 25 */    "Device is busy",
    /* 26 */    "File already exists",
    /* 27 */    "Cross-device link",
    /* 28 */    "File is not a directory",
    /* 29 */    "File is a directory",
    /* 30 */    "Invalid argument",
    /* 31 */    "Currently there are too many files open on "
                "this machine",
    /* 32 */    "You have too many files open",
    /* 33 */    "Not a character device",
    /* 34 */    "Text file busy",
    /* 35 */    "File is too large",
    /* 36 */    "File system is full",
    /* 37 */    "Attempted seek on a pipe",
    /* 38 */    "File system is read only",
    /* 39 */    "Too many links",
    /* 40 */    "Broken pipe",
    /* 41 */    "Math function argument was out of domain",
    /* 42 */    "Math result is not representable",

    /* SystemV */

    /* 43 */    "File system needs cleaning",
    /* 44 */    "Would deadlock",
    /* 45 */    "Invalid semaphore identifier",
    /* 46 */    "Semaphore not available",
    /* 47 */    "Is a semaphore",
    /* 48 */    "There is no message of that type",
    /* 49 */    "Identifier removed",
    /* 50 */    "No locks available",
    /* 51 */    "(operating system delivered an unknown "
                "error code)",

    /* BSD-Unix */

    /* 52 */    "Operation would block the process",
    /* 53 */    "Operation is now in progress",
    /* 54 */    "Operation is already in progress",
    /* 55 */    "Socket operation on non-socket",
    /* 56 */    "Destination address required",
    /* 57 */    "Message too long",
    /* 58 */    "Protocol wrong type for socket",
    /* 59 */    "Bad protocol option",
    /* 60 */    "Protocol is not supported",
    /* 61 */    "Socket type is not supported",
    /* 62 */    "Operation is not supported on socket",
    /* 63 */    "Protocol family is not supported",
    /* 64 */    "Address family is not supported",
    /* 65 */    "Address is already in use",
    /* 66 */    "Can't assign requested address",
    /* 67 */    "Network is down",
    /* 68 */    "Network is unreachable",
    /* 69 */    "Network dropped connection on reset",
    /* 70 */    "Operating system caused connection abort",
    /* 71 */    "Connection reset by peer",
    /* 72 */    "No buffer space available",
    /* 73 */    "Socket is already connected",
    /* 74 */    "Socket is not connected",
    /* 75 */    "Can't send after socket shutdown",
    /* 76 */    "Connection timed out",
    /* 77 */    "Connection refused",
    /* 78 */    "Too many levels of symbolic links",
    /* 79 */    "File name is too long",
    /* 80 */    "Directory is not empty",
#endif
};

#define str_inex_result "Inexact result"
#define str_div_zero    "Division by zero"
#define str_underflow   "Underflow"
#define str_overflow    "Overflow"
#define str_operror     "Invalid operand"
#define str_unordered   "Unordered compare"
#define str_snan        "Operand is a signaling NaN"
