/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_FileIO.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Interface file for safe file open and close.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_FILEIO_H__
#define __UT_FILEIO_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include "UT_Compat.h"

extern POIMG_IMPORT_EXPORT Int32    UT_FileGetMaxOpenFiles (void);
extern POIMG_IMPORT_EXPORT Int32    UT_FileGetNumOpenFiles (void);
extern POIMG_IMPORT_EXPORT UT_Bool  UT_FileCheck (void);
extern POIMG_IMPORT_EXPORT FILE    *UT_FileOpen  (const char *name, const char *mode);
extern POIMG_IMPORT_EXPORT UT_Bool  UT_FileClose (FILE *fp);

#ifdef __cplusplus
}
#endif

#endif /* __UT_FILEIO_H__ */
