/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Image.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declaration of a vector font defining all printable
 *                      ASCII characters (see UT_Image.c), and some macros
 *                      for using the font.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_IMAGE_H__
#define __UT_IMAGE_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Compat.h"

extern POIMG_IMPORT_EXPORT void UT_ImgDitherTable (Int16 tbl[], Int32 sz, Int32 maxval);
extern POIMG_IMPORT_EXPORT void UT_ImgGammaTable  (Float32 gamma, Int32 n, Int32 maxval, Int16 g[]);

/* A "noise generator" used as input for the "noise" function. */

#define UT_ImgNoiseBits 12
#define UT_ImgNoiseSize (1 << UT_ImgNoiseBits)

typedef struct {
    UInt16  hashtable[UT_ImgNoiseSize];
    Float32 randtable[UT_ImgNoiseSize + 3];
} UT_ImgNoiseGen;

extern POIMG_IMPORT_EXPORT void    UT_ImgMakeNoiseGen (Int32 seed, UT_ImgNoiseGen *gen);
extern POIMG_IMPORT_EXPORT Float32 UT_ImgNoise (const UT_ImgNoiseGen *gen, Int32 p,
                                                Float32 x, Float32 y, Float32 z);

/* A data type to describe colors according to the
   Commission Internationale de L'Eclairage (CIE) */

typedef struct {Float32 x, y;} CIE_hue;

extern POIMG_IMPORT_EXPORT const char *UT_VectorFont[256];

/* Determine the x and y coordinates of a point */

#define VECFONT_X(p) ((*(p) & 0x70) >> 4)
#define VECFONT_Y(p) (*(p) & 0x0f)

/* Distinguish between "moves" and "draws" */

#define VECFONT_DRAW(p) (*(p) & 0x80)

/* Find the string defining the shape of a character */

#define VECFONT_STRING(c) ((UInt8 *)(UT_VectorFont[(UInt8)(c)]))

#ifdef __cplusplus
}
#endif

#endif /* __UT_IMAGE_H__ */
