/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Macros.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Useful machine-independent macro definitions.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_MACROS_H__
#define __UT_MACROS_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Export.h"
#include "UT_Const.h"

#define UT_MIN(x,y) ((x) < (y)? (x): (y))
#define UT_MAX(x,y) ((x) > (y)? (x): (y))

#define UT_ABS(x) ((x) >= 0? (x): -(x))
#define UT_SGN(x) ((x) > 0? 1: ((x) < 0? -1: 0))

#define UT_SQR(x) ((x) * (x))

#define UT_DEG2RAD(x) ((x) * (UT_PI / 180.0))
#define UT_RAD2DEG(x) ((x) * (180.0 / UT_PI))

#define UT_SWAP(a,b,type) {type tmp; tmp = a; a = b; b = tmp;}

#define UT_FloatIsZero(a)       (UT_ABS((a)) < MinNrmFloat32)
#define UT_DoubleIsZero(a)      (UT_ABS((a)) < MinNrmFloat64)

#define UT_FloatsAreEqual(a,b)  (UT_ABS((a)-(b)) < MinNrmFloat32)
#define UT_DoublesAreEqual(a,b) (UT_ABS((a)-(b)) < MinNrmFloat64)

#define UT_FloatsAreEqualDelta(a,b,d)  (UT_ABS((a)-(b)) < (d))
#define UT_DoublesAreEqualDelta(a,b,d) (UT_ABS((a)-(b)) < (d))

#ifdef __cplusplus
}
#endif

#endif /* __UT_MACROS_H__ */
