/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Math.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Miscellaneous mathematical functions.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_MATH_H__
#define __UT_MATH_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Compat.h"

/* Select the entry in row "r" and column "c"
   from a matrix, "m", with "nc" columns. */

#define UT_MATRIX(m,nc,r,c) (m[(r)*(nc)+(c)])

/* Functions defined in "UT_MathGauss.c" */

extern POIMG_IMPORT_EXPORT UT_Bool UT_MathGaussSolve
        (UT_Bool, Int32, const Float64 *, Float64 *,
        Int32 *, const Float64 *, Float64 *, Float64 *);

/* Functions defined in "UT_MathHardy.c" */

extern POIMG_IMPORT_EXPORT UT_Bool UT_MathHardyCoeff1
        (Int32, const Float32 *, const Float32 *,
        const Float64 *, Float64 *, Float64 *);
extern POIMG_IMPORT_EXPORT UT_Bool UT_MathHardyCoeff2
        (Int32, const Float32 *, const Float32 *,
        const Float64 *, Float64 *, Float64 *, Float32);
extern POIMG_IMPORT_EXPORT Float32 UT_MathHardy1
        (Int32, const Float32 *, const Float32 *,
        Float64, const Float64 *, Float32, Float32);
extern POIMG_IMPORT_EXPORT Float32 UT_MathHardy2
        (Int32, const Float32 *, const Float32 *,
        Float64, const Float64 *, Float32, Float32);
extern POIMG_IMPORT_EXPORT void UT_MathHardyGrad1
        (Int32, const Float32 *, const Float32 *,
        Float64, const Float64 *, Float32, Float32,
        Float32 *, Float32 *);
extern POIMG_IMPORT_EXPORT void UT_MathHardyGrad2
        (Int32, const Float32 *, const Float32 *,
        Float64, const Float64 *, Float32, Float32,
        Float32 *, Float32 *);

/* Functions defined in "UT_MathMisc.c" */

extern POIMG_IMPORT_EXPORT UInt32 UT_MathRoundUpPow2 (UInt32 val);

#ifdef __cplusplus
}
#endif

#endif /* __UT_MATH_H__ */
