/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_MathMisc.c
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Miscellaneous mathematical functions.
 *
 *      Additional documentation:
 *                      None.
 *
 *      Exported functions:
 *                      UT_MathRoundUpPow2
 *
 **************************************************************************/

#include "UT_Compat.h"
#include "UT_Math.h"

/***************************************************************************
 *[@e
 *      Name:           UT_MathRoundUpPow2
 *
 *      Usage:          Round up to next power of 2 value.
 *
 *      Synopsis:       UInt32 UT_MathRoundUpPow2 (UInt32 val)
 *
 *      Description:    Round the value given in "val" to the next power of 2.
 *
 *      Return value:   The next power of 2 value.
 *
 *      See also:
 *
 ***************************************************************************/

UInt32 UT_MathRoundUpPow2 (UInt32 val)
{
    val--;
    val |= val >>  1;
    val |= val >>  2;
    val |= val >>  4;
    val |= val >>  8;
    val |= val >> 16;
    return val+1;
}
