/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Misc.c
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Miscellaneous functions.
 *
 *      Additional documentation:
 *
 *      Exported functions:
 *                      UT_StringEqual
 *
 **************************************************************************/
#include <ctype.h>
#include <string.h>

#include "UT_Misc.h"

UT_Bool UT_StringEqual (const char *a, const char *b)
{
    if (!a || !b) {
        return UT_False;
    }
    if (strlen (a) != strlen (b) ) {
        return UT_False;
    }
    while (*a) {
        if (tolower(*a) != tolower(*b)) {
            return UT_False;
        }
        a++;
        b++;
    }
    return UT_True;
}
