/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Parallel.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Functions for dealing with parallelism-related issues
 *                      in a machine-independent way
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_PARALLEL_H__
#define __UT_PARALLEL_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Compat.h"

/* Definitions for threading control. */

#if defined (HAVE_THREADS)
    #define UT_THREAD_EXEC(funct, farg, n, stksize) \
        UT_ThreadExec ((funct), (farg), (n), (stksize))

#else
    #define UT_THREAD_EXEC(funct, farg, n, stksize) \
        ((funct) ((farg), 0, 0), UT_True)

#endif

extern POIMG_IMPORT_EXPORT UT_Bool UT_ThreadExec (void (*funct) (void *, Int32, Int32),
                              void *farg, Int32 n, Int32 stksiz);

#ifdef __cplusplus
}
#endif

#endif /* __UT_PARALLEL_H__ */
