/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Portable.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declaration of the functions used to convert
 *                      data into a machine-independent representation.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_PORTABLE_H__
#define __UT_PORTABLE_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Compat.h"

extern POIMG_IMPORT_EXPORT UT_Bool UT_PortIsIntel (void);

extern POIMG_IMPORT_EXPORT void UT_PortInt16ToByte    ( Int16 x,  UInt8 buf[2]);
extern POIMG_IMPORT_EXPORT void UT_PortUInt16ToByte   (UInt16 x,  UInt8 buf[2]);
extern POIMG_IMPORT_EXPORT void UT_PortInt32ToByte    ( Int32 x,  UInt8 buf[4]);
extern POIMG_IMPORT_EXPORT void UT_PortUInt32ToByte   (UInt32 x,  UInt8 buf[4]);
extern POIMG_IMPORT_EXPORT void UT_PortFloat32ToByte  (Float32 x, UInt8 buf[4]);
extern POIMG_IMPORT_EXPORT void UT_PortFloat32To3Byte (Float32 x, UInt8 buf[3]);
extern POIMG_IMPORT_EXPORT void UT_PortFloat32To2Byte (Float32 x, UInt8 buf[2]);
extern POIMG_IMPORT_EXPORT void UT_PortFloat64ToByte  (Float64 x, UInt8 buf[8]);

extern POIMG_IMPORT_EXPORT Int16   UT_PortByteToInt16    (const UInt8 buf[2]);
extern POIMG_IMPORT_EXPORT UInt16  UT_PortByteToUInt16   (const UInt8 buf[2]);
extern POIMG_IMPORT_EXPORT Int32   UT_PortByteToInt32    (const UInt8 buf[4]);
extern POIMG_IMPORT_EXPORT UInt32  UT_PortByteToUInt32   (const UInt8 buf[4]);
extern POIMG_IMPORT_EXPORT Float32 UT_PortByteToFloat32  (const UInt8 buf[4]);
extern POIMG_IMPORT_EXPORT Float32 UT_Port3ByteToFloat32 (const UInt8 buf[3]);
extern POIMG_IMPORT_EXPORT Float32 UT_Port2ByteToFloat32 (const UInt8 buf[2]);
extern POIMG_IMPORT_EXPORT Float64 UT_PortByteToFloat64  (const UInt8 buf[8]);

#ifdef __cplusplus
}
#endif

#endif /* __UT_PORTABLE_H__ */
