/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Random.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for a machine-independent 
 *                      random number generator.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_RANDOM_H__
#define __UT_RANDOM_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Compat.h"

typedef struct randomGen *UT_RandomGen;

extern POIMG_IMPORT_EXPORT UT_RandomGen UT_RandomNew (UInt32 seed);
extern POIMG_IMPORT_EXPORT void         UT_RandomDelete (UT_RandomGen rGen);

extern POIMG_IMPORT_EXPORT Int32   UT_RandomGetInt32   (UT_RandomGen rGen, Int32 rmin,   Int32 rmax);
extern POIMG_IMPORT_EXPORT UInt32  UT_RandomGetUInt32  (UT_RandomGen rGen, UInt32 rmin,  UInt32 rmax);
extern POIMG_IMPORT_EXPORT Float32 UT_RandomGetFloat32 (UT_RandomGen rGen, Float32 rmin, Float32 rmax);

#ifdef __cplusplus
}
#endif

#endif /* __UT_RANDOM_H__ */
