/**************************************************************************
 *{@C
 *      Copyright:      1988-2025 Paul Obermeier (obermeier@poSoft.de)
 *
 *      Module:         Utilities
 *      Filename:       UT_Swatch.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for time related and stop watch functions.
 *
 *      Additional documentation:
 *                      None.
 *
 **************************************************************************/

#ifndef __UT_SWATCH_H__
#define __UT_SWATCH_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "UT_Compat.h"

typedef struct swatchStruct *UT_Swatch;

extern POIMG_IMPORT_EXPORT Float64   UT_GetWallClockTime        (void);
extern POIMG_IMPORT_EXPORT Float64   UT_GetSecondsSinceMidnight (void);

extern POIMG_IMPORT_EXPORT UT_Swatch UT_SwatchNew    (void);
extern POIMG_IMPORT_EXPORT void      UT_SwatchDelete (UT_Swatch sw);
extern POIMG_IMPORT_EXPORT void      UT_SwatchStop   (UT_Swatch sw);
extern POIMG_IMPORT_EXPORT void      UT_SwatchRun    (UT_Swatch sw);
extern POIMG_IMPORT_EXPORT void      UT_SwatchReset  (UT_Swatch sw);
extern POIMG_IMPORT_EXPORT Float64   UT_SwatchLookup (const UT_Swatch sw);

#ifdef __cplusplus
}
#endif

#endif /* __UT_SWATCH_H__ */
