# Module:         poSwatchUtil
# Copyright:      Paul Obermeier 2013-2025 / paul@poSoft.de
# First Version:  2013 / 03 / 01
#
# Distributed under BSD license.
#
# Module with utility procedures for the swatch functionality of the
# poImg package.

namespace eval poSwatchUtil {
    variable ns [namespace current]

    namespace ensemble create

    namespace export NewSwatch DeleteSwatch

    proc NewSwatch {} {
        set swatch [poSwatch NewSwatch]
        $swatch Reset
        $swatch Run
        return $swatch
    }

    proc DeleteSwatch { sw } {
        rename $sw {}
    }
}
