# Module:         poVecUtil
# Copyright:      Paul Obermeier 2013-2025 / paul@poSoft.de
# First Version:  2013 / 03 / 01
#
# Distributed under BSD license.
#
# Module with utility procedures for the vector functionality of the
# poImg package.

namespace eval poVecUtil {
    variable ns [namespace current]

    namespace ensemble create

    namespace export DegToRad RadToDeg

    proc DegToRad { deg } {
        return [expr {$deg * $::PI / 180.0}]
    }

    proc RadToDeg { rad } {
        return [expr {$rad * 180.0 / $::PI}]
    }
}
