#------------------------------------------------------------------------
# ENABLE_IMG_MACROS --
#
#   Allows the building with macros instead of functions.
#
# Arguments:
#   None
#   
# Results:
#
#   Adds the following arguments to configure:
#       --enable-macros=yes|no
#   Default is yes.
#
#   Defines the following vars:
#       USE_IMG_MACROS
#
#------------------------------------------------------------------------

AC_DEFUN(ENABLE_IMG_MACROS, [
    AC_MSG_CHECKING([whether to enable image macros])
    AC_ARG_ENABLE(macros,
        AS_HELP_STRING([--enable-macros],
            [build poImg with image macros (default: on)]),
        [tcl_ok=$enableval], [tcl_ok=yes])

    if test "${enable_macros+set}" = set; then
        enableval="$enable_macros"
        tcl_ok=$enableval
    else
        tcl_ok=yes
    fi

    if test "$tcl_ok" = "yes" ; then
        AC_MSG_RESULT([yes])
        AC_DEFINE(USE_IMG_MACROS)
    else
        AC_MSG_RESULT([no])
    fi
])


#------------------------------------------------------------------------
# ENABLE_TK_PHOTOS --
#
#   Allows the building with Tk photo images.
#
# Arguments:
#   None
#   
# Results:
#
#   Adds the following arguments to configure:
#       --enable-tkphotos=yes|no
#   Default is yes.
#
#   Defines the following vars:
#       USE_TK_PHOTOS
#
#------------------------------------------------------------------------

AC_DEFUN(ENABLE_TK_PHOTOS, [
    AC_MSG_CHECKING([whether to enable Tk photos])
    AC_ARG_ENABLE(tkphotos,
        AS_HELP_STRING([--enable-tkphotos],
            [build poImg with Tk photos (default: on)]),
        [tcl_ok=$enableval], [tcl_ok=yes])

    if test "${enable_tkphotos+set}" = set; then
        enableval="$enable_tkphotos"
        tcl_ok=$enableval
    else
        tcl_ok=yes
    fi

    if test "$tcl_ok" = "yes" ; then
        AC_MSG_RESULT([yes])
        AC_DEFINE(USE_TK_PHOTOS)
    else
        AC_MSG_RESULT([no])
    fi
])


#------------------------------------------------------------------------
# ENABLE_MEM_DEBUG --
#
#   Allows the building with memory debugging enabled.
#
# Arguments:
#   None
#   
# Results:
#
#   Adds the following arguments to configure:
#       --enable-memdebug=yes|no
#   Default is no.
#
#   Defines the following vars:
#       USE_MEM_DEBUG
#
#------------------------------------------------------------------------

AC_DEFUN(ENABLE_MEM_DEBUG, [
    AC_MSG_CHECKING([whether to enable memory debugging])
    AC_ARG_ENABLE(memdebug,
        AS_HELP_STRING([--enable-memdebug],
            [build poImg with memory debugging (default: off)]),
        [tcl_ok=$enableval], [tcl_ok=no])

    if test "${enable_memdebug+set}" = set; then
        enableval="$enable_memdebug"
        tcl_ok=$enableval
    else
        tcl_ok=no
    fi

    if test "$tcl_ok" = "yes" ; then
        AC_MSG_RESULT([yes])
        AC_DEFINE(USE_MEM_DEBUG)
    else
        AC_MSG_RESULT([no])
    fi
])
