source pkgsNeeded.tcl

ui_init "t_blend.tcl"
SetFileTypes

PH "Image blending with Tcl functions"

proc warpFuncIdent { x y } {
    return [list $x $y]
}

proc warpFuncShift1 { x y } {
    set nx [expr {$x + $::gOffset(x,1)}]
    set ny [expr {$y + $::gOffset(y,1)}]
    return [list $nx $ny]
}

proc warpFuncShift2 { x y } {
    set nx [expr {$x + $::gOffset(x,2)}]
    set ny [expr {$y + $::gOffset(y,2)}]
    return [list $nx $ny]
}

proc warpFunc1 { x y } {
    set nx [expr {$x - 0.2 * $y}]
    set ny $y
    return [list $nx $ny]
}

proc warpFunc2 { x y } {
    set nx [expr {$x + 0.2 * $y}]
    set ny $y
    return [list $nx $ny]
}

proc warpDeriv { x y } {
    set ux 1
    set uy 1
    set vx 1
    set vy 1
    return [list $ux $uy $vx $vy]
}

proc blendFunc { x y } {
    return $::gMixFactor
}

proc resetOffsets {} {
    set ::gOffset(x,1) 0.0
    set ::gOffset(y,1) 0.0
    set ::gOffset(x,2) 0.0
    set ::gOffset(y,2) 0.0
}

set srcimg1 [poImgUtil NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$srcimg1 GetImageInfo w h a

set srcimg2 [poImgUtil NewImageFromFile "[GetTestInDir]/Tree$fInfo(suf)"] 
set dstimg  [poImage NewImage $w $h $a]

set msg "Original image1"
ui_addimg $srcimg1 $msg
set msg "Original image2"
ui_addimg $srcimg2 $msg

set gMixFactor 0.3
set fname "testOut/blend1a$fInfo(suf)"
set msg   "$fname: Blending (using BlendFunct) with mix factor $gMixFactor"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFuncIdent warpDeriv warpFuncIdent warpDeriv blendFunc 3 $WRAP
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

set fname "testOut/blend1b$fInfo(suf)"
set msg   "$fname: Blending (using poImgUtil::Blend) with mix factor $gMixFactor"
P $msg
set blendimg [poImgUtil::Blend $srcimg1 $srcimg2 $gMixFactor]
$blendimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $blendimg $msg

set gMixFactor 0.7
set fname "testOut/blend2$fInfo(suf)"
set msg   "$fname: Blending (using BlendFunct) with mix factor $gMixFactor"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFuncIdent warpDeriv warpFuncIdent warpDeriv blendFunc 3 $WRAP
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg


resetOffsets
set gMixFactor   1.0
set gOffset(x,1) 0.3
set fname "testOut/blend3$fInfo(suf)"
set msg   "$fname: Horizontal shifting using fill mode CLIP"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFuncShift1 warpDeriv warpFuncShift2 warpDeriv blendFunc 3 $CLIP
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

set fname "testOut/blend4$fInfo(suf)"
set msg   "$fname: Horizontal shifting using fill mode WRAP"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFuncShift1 warpDeriv warpFuncShift2 warpDeriv blendFunc 3 $WRAP
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

poImgUtil SetDrawColorRGB 1.0 0.1 0.1
set fname "testOut/blend5$fInfo(suf)"
set msg   "$fname: Horizontal shifting using fill mode FILL"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFuncShift1 warpDeriv warpFuncShift2 warpDeriv blendFunc 3 $FILL
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg


resetOffsets
set gMixFactor    0.7
set gOffset(y,1) -0.2
set fname "testOut/blend6$fInfo(suf)"
set msg   "$fname: Blending and vertical shifting using fill mode WRAP"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFuncShift1 warpDeriv warpFuncShift2 warpDeriv blendFunc 6 $WRAP
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

set fname "testOut/blend7$fInfo(suf)"
set msg   "$fname: Blending and warping using fill mode WRAP"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFunc1 warpDeriv warpFunc2 warpDeriv blendFunc 3 $WRAP
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

set gMixFactor 1.0
set fname "testOut/blend8$fInfo(suf)"
set msg   "$fname: Warping using fill mode CLIP"
P $msg
$dstimg BlendFunct $srcimg1 $srcimg2 \
        warpFunc1 warpDeriv warpFunc2 warpDeriv blendFunc 6 $CLIP
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg


PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
