source pkgsNeeded.tcl

ui_init "t_blur.tcl"
SetFileTypes

PH "Image blurring commands"

set sw [poSwatchUtil NewSwatch]

set img [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$img GetImageInfo w h a

set imgsave [poImage NewImage $w $h $a]
$imgsave CopyImage $img

set msg "Original image"
ui_addimg $img $msg

set fname "testOut/blur3x3$fInfo(suf)"
set msg   "$fname: Blur filtering by 3"
P $msg
$img CopyImage $imgsave
$img Blur 3
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/blur8x1$fInfo(suf)"
set msg   "$fname: Blur filtering by 8x1"
P $msg
$img CopyImage $imgsave
$img Blur 8 1
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/blurDepth$fInfo(suf)"
set msg   "$fname: Depthblur filtering by 8"
P $msg
poImgUtil SetFormatChan $DEPTH $FLOAT
set imgdepth [poImage NewImage $w $h $a]
$imgdepth CopyImage $imgsave
poImgUtil SetDrawMaskRGB $OFF $OFF $OFF
poImgUtil SetDrawMaskChan $DEPTH $ON
for { set y 0 } { $y < $h } { incr y } {
    poImgUtil SetDrawColorChan $DEPTH [expr double ($y) / double ($h)]
    $imgdepth DrawLine 0 $y $w $y
}
# Rectangle specified with -1 means use whole image.
$imgdepth GetChannelRange "DEPTH" -1 -1 -1 -1 dmin dmax
P "Depth range in image is from [PF $dmin] to [PF $dmax]"
poImgUtil SetDrawMaskRGB $ON $ON $ON
poImgUtil SetDrawMaskChan $DEPTH $OFF
$imgdepth DepthBlur 8 8
$imgdepth WriteImage $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgdepth $msg

set msg "Depth channel of previous image"
P $msg
ui_addimg $imgdepth $msg -chanmap [list $DEPTH $DEPTH $DEPTH]

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $img
poImgUtil DeleteImage $imgsave

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
