source pkgsNeeded.tcl

ui_init "t_brush.tcl"
SetFileTypes

proc DrawPattern { img brush r g b } {
    global imgSize

    for { set x 0 } { $x < $imgSize } { incr x 50 } {
        poImgUtil SetDrawColorRGB $r $g $b
        set intens 1.0
        for { set y 0 } { $y < $imgSize } { incr y 50 } {
            $img DrawBrush $brush $x $y $intens
            set intens [expr ($intens - 0.1)]
        }
        set r [expr ($r - 0.1)]
        set g [expr ($g - 0.1)]
        set b [expr ($b - 0.1)]
    }
}

PH "Drawing with brushes"

set imgSize 550

set img1 [poImage NewImage $imgSize $imgSize]
set img2 [poImage NewImage $imgSize $imgSize]
set img3 [poImage NewImage $imgSize $imgSize]

P "Reading brush image files"
set brush1 [poImage NewImageFromFile "[GetTestInDir]/keksi.bsh"]
set brush2 [poImage NewImageFromFile "[GetTestInDir]/star.bsh"]

P "Creating brush image file"
set brushTmpl [poImage NewImageFromFile "[GetTestInDir]/star_bsh.rgb"]
set brush3 [poImgUtil CreateBrushImage $brushTmpl "RED"]

$img1 Blank
$img2 Blank
$img3 Blank

set fname "testOut/brushKeksi$fInfo(suf)"
set msg   "$fname: Drawing white keksi brushes"
P $msg
DrawPattern $img1 $brush1 1.0 1.0 1.0
$img1 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img1 $msg

set fname "testOut/brushStar$fInfo(suf)"
set msg "$fname: Drawing red star brushes"
P $msg
DrawPattern $img2 $brush2 1.0 0 0
$img2 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img2 $msg

RandomInit 0
set fname "testOut/brushMerge$fInfo(suf)"
set msg   "$fname: Merging brushes at 50 random locations"
P $msg
for { set i 0 } { $i <= 50 } { incr i } {
    set x [RandomRange 250]
    set y [RandomRange 250]
    set intens [Random]
    set imgNum [expr ([RandomRange 100] % 2)]

    #puts -nonewline "Merging brush at ([format "%3d, %3d" $x $y]) "
    #puts           "with intensity [format "%4.2f" $intens]"
    if { $imgNum } {
        $img3 MergeBrush $img1 $brush2 $x $y $intens
    } else {
        $img3 MergeBrush $img2 $brush3 $x $y $intens
    }
}
$img3 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img3 $msg

set fname "testOut/brushLine$fInfo(suf)"
set msg   "$fname: Drawing keksi brush lines"
P $msg
$img1 Blank
poImgUtil SetDrawColorRGB 0 1 0
$img1 DrawBrushLine $brush1  50 0  50 $imgSize  1 0.5
$img1 DrawBrushLine $brush1 110 0 110 $imgSize 10 0.5
$img1 DrawBrushLine $brush1 170 0 170 $imgSize 20 0.5
$img1 DrawBrushLine $brush1   0 0 $imgSize $imgSize 30 0.3
$img1 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img1 $msg

poImgUtil DeleteImage $brush1 $brush2  $brush3
poImgUtil DeleteImage $brushTmpl

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
