source pkgsNeeded.tcl

ui_init "t_catmap.tcl"
SetFileTypes

PH "Arnold's cat map"
# http://online.redwoods.cc.ca.us/instruct/darnold/maw/catmap.htm

set imgsize 124
set numIter 15

set sw [poSwatchUtil NewSwatch]

# Read in the test image.
set imgorig [poImage NewImageFromFile "[GetTestInDir]/TeapotSquare$fInfo(suf)"]
$imgorig GetImageInfo w h a g

# Scale the image to be square.
set imgsave [poImage NewImage $imgsize $imgsize 1.0 $g]
$imgsave ScaleRect $imgorig \
         0 0 $w $h \
         0 0 $imgsize $imgsize

# Save the square image as iteration zero.
set iter 0
set fname "testOut/catmap.[format "%03d" $iter]$fInfo(suf)"
set msg   "$fname: Iteration [format "%03d" $iter] ($imgsize x $imgsize)."
P $msg
$imgsave WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgsave $msg

set in  0
set out 1
set img(0) [$imgsave CopyImage]
set img(1) [$imgsave CopyImage]

for { set iter 1 } { $iter <= $numIter } { incr iter } {
    $img($out) Blank
    set fname "testOut/catmap.[format "%03d" $iter]$fInfo(suf)"
    set msg   "$fname: Iteration [format "%03d" $iter] ($imgsize x $imgsize)."
    P $msg

    for { set y 0 } { $y < $imgsize } { incr y } {
        for { set x 0 } { $x < $imgsize } { incr x } {
            set nx [expr {($x + $y) % $imgsize}]
            set ny [expr {($x + 2*$y) % $imgsize}]
            $img($in) GetPixel $x $y pixel
            poImageState SetDrawColor $pixel
            $img($out) DrawPixel $nx $ny
        }
    }
    $img($out) WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $img($out) $msg
    set in  [expr ($in  + 1) % 2]
    set out [expr ($out + 1) % 2]
}

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $imgorig
poImgUtil DeleteImage $imgsave
poImgUtil DeleteImage $img(0)
poImgUtil DeleteImage $img(1)

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
