source pkgsNeeded.tcl

ui_init "t_chanmap.tcl"
SetFileTypes

PH "Photo image channel mapping"

set color(0) [list $RED $GREEN $BLUE]
set color(1) [list]
set color(2) [list $RED $RED $RED]
set color(3) [list $RED $GREEN $GREEN]
set color(4) [list $BLUE $GREEN $RED]
set color(5) [list $RED $GREEN $BLUE $MATTE]
set color(6) [list $MATTE $MATTE $MATTE]
set color(7) [list $DEPTH $DEPTH $DEPTH]
set color(8) [list $TEMPERATURE $TEMPERATURE $TEMPERATURE]
set color(9) [list $RADIANCE $RADIANCE $RADIANCE]
set numMaps 10

poImgUtil SetFormatChan $MATTE       $UBYTE
poImgUtil SetFormatChan $DEPTH       $FLOAT
poImgUtil SetFormatChan $TEMPERATURE $FLOAT
poImgUtil SetFormatChan $RADIANCE    $FLOAT
set fname "[GetTestInDir]/Teapot$fInfo(suf)"
poImageState GetFileInfo $fname w h
set img [poImage NewImage $w $h]
$img ReadImage $fname

poImgUtil SetDrawMaskRGB $OFF $OFF $OFF
poImgUtil SetDrawColorChan $MATTE 1.0
$img DrawRect 0 $h $w [expr $h - 20]
$img DrawText 10 100 "Matte chan"

for { set y 0 } { $y <= 100 } { incr y } {
    poImgUtil SetDrawColorChan $MATTE [expr double($y) / 100.0]
    $img DrawRect 0 $y $w $y
}
poImgUtil SetDrawMaskChan $MATTE $OFF

poImgUtil SetDrawColorChan $DEPTH 1.0
$img DrawText 10 100 "Depth chan"
poImgUtil SetDrawMaskChan $DEPTH $OFF

for { set i 270 } { $i < 370 } { incr i 20 } {
    poImgUtil SetDrawColorChan $TEMPERATURE $i
    $img DrawText 0 [expr $i - 270] "Temperature"
}
poImgUtil SetDrawMaskChan $TEMPERATURE $OFF

for { set i 270 } { $i < 370 } { incr i 20 } {
    poImgUtil SetDrawColorChan $RADIANCE $i
    $img DrawText 0 [expr $i - 270] "Radiance"
}
poImgUtil SetDrawMaskChan $RADIANCE $OFF

for { set i 0 } { $i < $numMaps } { incr i } {
    set colList $color($i)
    set fname [format "testOut/chanmap.%03d.png" $i]
    set msg "$fname: Channel mapping values: $colList"
    P $msg
    ui_addimg $img $msg -chanmap $colList
    set phImg [ui_getphoto $i]
    $phImg write $fname -format "png"
}

poImgUtil DeleteImage $img

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
