source pkgsNeeded.tcl

ui_init "t_colorbar.tcl"
SetFileTypes

PH "Draw colorbar image and save in different formats"

set w  80
set h 120

# Create a RGBA image.
poImageState PushState
poImgUtil SetFormatRGBA $UBYTE $UBYTE $UBYTE $UBYTE
set imgRgba [poImage NewImage $w $h]
$imgRgba Blank

# Draw color bar from left to right: Red, Green, Blue, Black, White, Cyan, Magenta, Yellow.
poImgUtil SetDrawColorRGB 1 0 0
$imgRgba DrawRect  0 0  9 39
poImgUtil SetDrawColorRGB 0 1 0
$imgRgba DrawRect 10 0 19 39
poImgUtil SetDrawColorRGB 0 0 1
$imgRgba DrawRect 20 0 29 39
poImgUtil SetDrawColorRGB 0 0 0
$imgRgba DrawRect 30 0 39 39
poImgUtil SetDrawColorRGB 1 1 1
$imgRgba DrawRect 40 0 49 39
poImgUtil SetDrawColorRGB 0 1 1
$imgRgba DrawRect 50 0 59 39
poImgUtil SetDrawColorRGB 1 0 1
$imgRgba DrawRect 60 0 69 39
poImgUtil SetDrawColorRGB 1 1 0
$imgRgba DrawRect 70 0 79 39

# Draw color bar from bottom to top: Red, Green, Blue, Black, White, Cyan, Magenta, Yellow.
poImgUtil SetDrawColorRGB 1 0 0
$imgRgba DrawRect 0  40  79 49
poImgUtil SetDrawColorRGB 0 1 0
$imgRgba DrawRect 0  50  79 59
poImgUtil SetDrawColorRGB 0 0 1
$imgRgba DrawRect 0  60  79 69
poImgUtil SetDrawColorRGB 0 0 0
$imgRgba DrawRect 0  70  79 79
poImgUtil SetDrawColorRGB 1 1 1
$imgRgba DrawRect 0  80  79 89
poImgUtil SetDrawColorRGB 0 1 1
$imgRgba DrawRect 0  90  79 99
poImgUtil SetDrawColorRGB 1 0 1
$imgRgba DrawRect 0 100  79 109
poImgUtil SetDrawColorRGB 1 1 0
$imgRgba DrawRect 0 110  79 119

# Draw 3 regions with different transparency values. 
poImgUtil SetDrawMaskRGBA $OFF $OFF $OFF $ON
poImgUtil SetDrawColorChan $MATTE 1.0  ; # Full opaque
$imgRgba DrawRect 0 0 $w $h
poImgUtil SetDrawColorChan $MATTE 0.5  ; # Half transparent
$imgRgba DrawRect 0 10 $w 19
poImgUtil SetDrawColorChan $MATTE 0.0  ; # Full transparent
$imgRgba DrawRect 0 30 $w 39

ui_addimg $imgRgba "Colorbar with transparency"

set tmpl "testOut/Colorbar-4chan-%s%s"
P "Saving 4-channel Colorbar"
foreach fmt { "poi" "raw" "sgi" "tga" } ext { ".poi" ".raw" ".rgba" ".tga" } {
    set fileName [format $tmpl "nocompr" $ext]
    P "  Save as $fileName"
    $imgRgba WriteSimple $fileName $fmt "-compression none"
    set fileName [format $tmpl "compr" $ext]
    P "  Save as $fileName"
    $imgRgba WriteSimple $fileName $fmt "-compression rle"
}
poImageState PopState

# Create a RGB image.
poImageState PushState
poImgUtil SetFormatRGB $UBYTE $UBYTE $UBYTE
set imgRgb [poImage NewImage $w $h]

# Copy the RGB channels from the RGBA image.
$imgRgb CopyChannel $imgRgba "RED"   "RED"
$imgRgb CopyChannel $imgRgba "GREEN" "GREEN"
$imgRgb CopyChannel $imgRgba "BLUE"  "BLUE"

ui_addimg $imgRgb "Colorbar without transparency"

set tmpl "testOut/Colorbar-3chan-%s%s"
P "Saving 3-channel colorbar"
foreach fmt { "poi" "raw" "sgi" "tga" } ext { ".poi" ".raw" ".rgb" ".tga" } {
    set fileName [format $tmpl "nocompr" $ext]
    P "  Save as $fileName"
    $imgRgb WriteSimple $fileName $fmt "-compression none"
    set fileName [format $tmpl "compr" $ext]
    P "  Save as $fileName"
    $imgRgb WriteSimple $fileName $fmt "-compression rle"
}
poImageState PopState

poImgUtil DeleteImage $imgRgb
poImgUtil DeleteImage $imgRgba

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
