source pkgsNeeded.tcl

proc Max { a b } {
    if { $a > $b } {
        return $a
    } else {
        return $b
    }
}

proc AltDiff { img1 img2 } {
    global ADD SUB REPLACE

    $img1 GetImageInfo w1 h1
    $img2 GetImageInfo w2 h2

    set w [Max $w1 $w2]
    set h [Max $h1 $h2]

    poImageState GetDrawMode savedMode

    poImgUtil SetDrawModeRGBA "SUB" "SUB" "SUB" "SUB"
    set tempImg [$img1 CopyImage]
    $tempImg CopyRect $img2 0 0 $w $h 0 0
    set diffImg [$img2 CopyImage]
    $diffImg CopyRect $img1 0 0 $w $h 0 0
    poImgUtil SetDrawModeRGBA "ADD" "ADD" "ADD" "ADD"
    $diffImg CopyRect $tempImg 0 0 $w $h 0 0

    poImageState SetDrawMode $savedMode

    poImgUtil DeleteImage $tempImg
    return $diffImg
}

ui_init "t_diff.tcl"
SetFileTypes

PH "Image comparison functions"

set sw [poSwatchUtil NewSwatch]

set img1 [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
set img2 [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$img1 GetImageInfo w h

# Generate a difference image out of two identical images.
# The difference image must be completely black and the number of marked
# pixels must be zero.
set fname "testOut/diffIdentical$fInfo(suf)"
set msg   "$fname: Difference of two identical images"
P $msg
set diffImg [$img1 DifferenceImage $img2]
set markImg [$diffImg MarkNonZeroPixels 0 numMarked]
if { $numMarked != 0 } {
    PE "Found $numMarked non-zero pixels (Should be zero)"
}
$diffImg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $diffImg $msg
poImgUtil DeleteImage $diffImg $markImg

# Draw a green pixel in one of the images and then generate a difference
# image. The number of marked pixels must be 1.
# In this case we calculate a second difference image with the old method
# of subtracting and adding the channels (see AltDiff at the top of the file).
poImgUtil SetDrawColorRGB 0 1 0
$img2 DrawPixel 100 100

set fname "testOut/diffOnePixel$fInfo(suf)"
set msg   "$fname: Difference of nearly identical images"
P $msg
set diff1Img [$img1 DifferenceImage $img2]
set diff2Img [AltDiff $img1 $img2]
set markImg [$diff1Img MarkNonZeroPixels 0 numMarked]
if { $numMarked != 1 } {
    PE "Method1: Found $numMarked non-zero pixels (Should be 1)"
}
poImgUtil DeleteImage $markImg
set markImg [$diff2Img MarkNonZeroPixels 0 numMarked]
if { $numMarked != 1 } {
    PE "Method2: Found $numMarked non-zero pixels (Should be 1)"
}
poImgUtil DeleteImage $markImg
$diff1Img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $diff1Img $msg
poImgUtil DeleteImage $diff1Img
poImgUtil DeleteImage $diff2Img

# Erode one of the images and then generate a difference image.
$img2 Erosion 3

set fname "testOut/diffErode$fInfo(suf)"
set msg   "$fname: Difference of original and eroded image"
P $msg
set diffImg [$img1 DifferenceImage $img2]
$diffImg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $diffImg $msg
poImgUtil DeleteImage $diffImg

poImgUtil DeleteImage $img1
poImgUtil DeleteImage $img2

# Draw a synthetic difference image with 9 non-zero pixels
# for testing the MarkNonZeroPixels function.
set srcImg [poImage NewImage $w $h]
$srcImg Blank

poImgUtil SetDrawColorRGB [expr 1.0 / 255.0] 0 0
$srcImg DrawPixel 50 100
poImgUtil SetDrawColorRGB 1 0 0
$srcImg DrawPixel 60 100
poImgUtil SetDrawColorRGB 0 1 0
$srcImg DrawPixel 70 100
poImgUtil SetDrawColorRGB 0 0 1
$srcImg DrawPixel 80 100
poImgUtil SetDrawColorRGB 1 1 1
$srcImg DrawPixel 90 100
poImgUtil SetDrawColorRGB 0 1 0
$srcImg DrawPixel 0 0
$srcImg DrawPixel [expr $w-1] 0
$srcImg DrawPixel 0 [expr $h-1]
$srcImg DrawPixel [expr $w-1] [expr $h-1]

set msg "Synthetic difference image"
ui_addimg $srcImg $msg

set markImg [poImage NewImage $w $h]

set threshold 0
set fname "testOut/diffThres_$threshold$fInfo(suf)"
set msg   "$fname: Non-Zero pixels (Threshold: $threshold)"
P $msg
$markImg MarkNonZeroPixels $threshold numMarked $srcImg
if { $numMarked != 9 } {
    PE "Found $numMarked non-zero pixels (Should be 9)"
}
$markImg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $markImg $msg

set threshold 1
set fname "testOut/diffThres_$threshold$fInfo(suf)"
set msg   "$fname: Non-Zero pixels (Threshold: $threshold)"
P $msg
$markImg MarkNonZeroPixels $threshold numMarked $srcImg
if { $numMarked != 8 } {
    PE "Found $numMarked non-zero pixels (Should be 8)"
}
$markImg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $markImg $msg
poImgUtil DeleteImage $markImg

poImgUtil DeleteImage $srcImg

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
