source pkgsNeeded.tcl

ui_init "t_draw.tcl"
SetFileTypes

proc DrawHorizLine { i x1 x2 y r g b } {
    global mode

    # puts "Line ($x1, $y) --> ($x2, $y) Color ($r, $g, $b)"
    poImgUtil SetDrawColorRGB $r $g $b
    if { $mode == 1 } {
        $i DrawLine $x1 $y $x2 $y
    } elseif { $mode == 2 } {
        $i DrawRect $x1 $y $x2 $y
    } elseif { $mode == 3 } {
        for { set x $x1 } { $x <= $x2 } { incr x } {
            $i DrawPixel $x $y
        }
    } elseif { $mode == 4 } {
        poImageState GetDrawColor clr1
        set clr2 { 0 0 0 0 }
        $i DrawAALine $x1 $y $x2 $y $clr1 $clr2
    } elseif { $mode == 5 } {
        for { set x $x1 } { $x <= $x2 } { incr x } {
            poImageState GetDrawColor clr1
            $i DrawAAPixel $x $y $clr1
        }
    }
}

PH "Drawing points, lines, rectangles and circles"

set w 400
set h 400

set img [poImage NewImage $w $h]
set lay [poImage NewImageFromFile "[GetTestInDir]/TeapotSquare$fInfo(suf)"]
$lay GetImageInfo wl hl
$lay GetImageFormat layfmt
P "Channels of image layer [GetTestInDir]/tree$fInfo(suf)"
poImgUtil PrintChans $layfmt Format

set sw [poSwatchUtil NewSwatch]

for { set mode 1 } { $mode <= 5 } { incr mode } {
    set x1 -20
    set x2 [expr ($w + 20)]
    $img Blank
    set fname "testOut/drawHori$mode$fInfo(suf)"

    if { $mode == 1 } {
        set msg "$fname: Drawing horizontal lines with DrawLine"        
    } elseif { $mode == 2 } {
        set msg "$fname: Drawing horizontal lines with DrawRect"        
    } elseif { $mode == 3 } {
        set msg "$fname: Drawing horizontal lines with DrawPixel"       
    } elseif { $mode == 4 } {
        set msg "$fname: Drawing horizontal lines with DrawAALine"      
        $img ScaleRect $lay 0 0 $wl $hl 0 0 $w $h
    } elseif { $mode == 5 } {
        set msg "$fname: Drawing horizontal lines with DrawAAPixel"     
        $img ScaleRect $lay 0 0 $wl $hl 0 0 $w $h
    }
    P $msg

    for { set y 0 } { $y <= $h } { incr y 8 } {
        DrawHorizLine $img $x1 $x2 [expr ($y +0)] 1 1 1 ; # White Line
        DrawHorizLine $img $x1 $x2 [expr ($y +1)] 1 0 0 ; # Red Line
        DrawHorizLine $img $x1 $x2 [expr ($y +2)] 0 1 0 ; # Green Line
        DrawHorizLine $img $x1 $x2 [expr ($y +3)] 0 0 1 ; # Blue Line
        DrawHorizLine $img $x1 $x2 [expr ($y +4)] 1 1 0 ; # Yellow Line
        DrawHorizLine $img $x1 $x2 [expr ($y +5)] 1 0 1 ; # Magenta Line
        DrawHorizLine $img $x1 $x2 [expr ($y +6)] 0 1 1 ; # Cyan Line
        DrawHorizLine $img $x1 $x2 [expr ($y +7)] 0 0 0 ; # Black Line
        set x1 [ expr ( $x1 + 10)]
        set x2 [ expr ( $x2 - 10)]
    }
    
    $img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $img $msg
}

set fname "testOut/drawLines$fInfo(suf)"
set msg   "$fname: Drawing white lines with DrawLine"
P $msg
$img Blank
poImgUtil SetDrawColorRGB 1 1 1
for { set x 0 } { $x <= $w } { incr x 4 } {
    $img DrawLine $x 0 [expr ($w - $x)] $h
}
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/drawStipple$fInfo(suf)"
set msg   "$fname: Drawing white stippled lines with DrawLine"
P $msg
$img Blank
poImgUtil SetDrawColorRGB 1 1 1
for { set x 0 } { $x <= $w } { incr x 4 } {
    $img DrawLine $x 0 [expr ($w - $x)] $h 3
}
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/drawAALines$fInfo(suf)"
set msg   "$fname: Drawing white lines with DrawAALine"
P $msg
$img Blank
set color { 0 1 1 1 }
for { set x 0 } { $x <= $w } { incr x 4 } {
    $img DrawAALine $x 0 [expr ($w - $x)] $h $color
}
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/drawStippleHori$fInfo(suf)"
set msg   "$fname: Drawing stippled horizontal lines"
P $msg
$img Blank
poImgUtil SetDrawColorRGB 1 1 1
set n 0
for { set y 10 } { $y < $h } { incr y 10 } {
    $img DrawLine 0 $y $w $y $n
    incr n
}
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/drawStippleVert$fInfo(suf)"
set msg   "$fname: Drawing stippled vertical lines"
P $msg
$img Blank
poImgUtil SetDrawColorRGB 1 1 1
set n 0
for { set x 10 } { $x < $w } { incr x 10 } {
    $img DrawLine $x 0 $x $h $n
    incr n
}
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/drawRects$fInfo(suf)"
set msg   "$fname: Drawing filled and outlined rectangles"
P $msg
$img Blank
# Drawing square rectangles.
poImgUtil SetDrawColorRGB 1 1 1
$img DrawRect  50 50 150 150
$img DrawRect 250 50 350 150 false
# Drawing landscape rectangles.
poImgUtil SetDrawColorRGB 1 0.5 0.5
$img DrawRect  40 200 150 250 $ON
$img DrawRect 250 200 360 250 false
# Drawing portrait rectangles.
poImgUtil SetDrawColorRGB 0 0.8 0.3
$img DrawRect 100 300 150 380 true
$img DrawRect 250 300 300 380 false
# Drawing rectangles extending the image size.
poImgUtil SetDrawColorRGB 0.1 0.3 0.8
$img DrawRect  -20 170 500 180
$img DrawRect  -20 270 500 280 false
$img DrawRect  180 -20 190 500
$img DrawRect  210 -20 220 500 false

$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/drawCircles$fInfo(suf)"
set msg   "$fname: Drawing ellipses and circles"
P $msg
$img Blank

poImgUtil SetDrawColorRGB 0.3 0.3 0.3
$img DrawCircle 200 200 220 true
poImgUtil SetDrawColorRGB 0.9 0.9 0.9
$img DrawCircle 200 200 221 false

poImgUtil SetDrawColorRGB 1 1 1
$img DrawCircle  200 100 40
poImgUtil SetDrawColorRGB 1 0 0
$img DrawEllipse 200 100 40 20

poImgUtil SetDrawColorRGB 1 1 1
$img DrawCircle  200 200 40
poImgUtil SetDrawColorRGB 0 1 0
$img DrawEllipse 200 200 20 40

poImgUtil SetDrawColorRGB 1 1 1
$img DrawCircle  200 300 40 false
poImgUtil SetDrawColorRGB 0 0 1
$img DrawEllipse 200 300 20 10

$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

# Draw text.

set imgtext [poImage NewImage 500 310]

set fname "testOut/drawText1$fInfo(suf)"
set str1 "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
set str2 "abcdefghijklmnopqrstuvwxyz"
set str3 {1234567890!"$%&/(){}[]\+-_.:,;}
set yellow { 0 1 1 0 }

$imgtext Blank

poImgUtil SetDrawColorRGB 1 1 1
poImageState GetTextSize $str1 wt ht
P "$fname: Drawing text $str1 (W=$wt H=$ht) with DrawText"
$imgtext DrawText 0 10 $str1

poImageState GetTextSize $str2 wt ht
P "$fname: Drawing text $str2 (W=$wt H=$ht) with DrawText"
$imgtext DrawText 0 30 $str2

poImageState GetTextSize $str3 wt ht
P "$fname: Drawing text $str3 (W=$wt H=$ht) with DrawText"
$imgtext DrawText 0 50 $str3

poImageState GetTextSize $str1 wt ht
P "$fname: Drawing text $str1 (W=$wt H=$ht) with DrawAAText"
$imgtext DrawAAText 0 70 $str1 $yellow

poImageState GetTextSize $str2 wt ht
P "$fname: Drawing text $str2 (W=$wt H=$ht) with DrawAAText"
$imgtext DrawAAText 0 90 $str2 $yellow

poImageState GetTextSize $str3 wt ht
P "$fname: Drawing text $str3 (W=$wt H=$ht) with DrawAAText"
$imgtext DrawAAText 0 110 $str3 $yellow

$imgtext WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgtext "$fname: 3 white rows with DrawText, 3 yellow rows with DrawAAText"

# Draw text with text scaling.

set fname "testOut/drawText2$fInfo(suf)"
$imgtext Blank

poImageState SetTextScale 2
poImageState GetTextSize $str1 wt ht
P "$fname: Drawing text $str1 (W=$wt H=$ht) with DrawText (scaling 2)"
$imgtext DrawText 0 10 $str1

poImageState SetTextScale 3
poImageState GetTextSize $str1 wt ht
P "$fname: Drawing text $str1 (W=$wt H=$ht) with DrawText (scaling 3)"
$imgtext DrawText 0 50 $str1

poImageState SetTextScale 4
poImageState GetTextSize $str1 wt ht
P "$fname: Drawing text $str1 (W=$wt H=$ht) with DrawText (scaling 4)"
$imgtext DrawText 0 100 $str1

poImageState SetTextScale 4
poImageState GetTextSize $str1 wt ht
P "$fname: Drawing text $str1 (W=$wt H=$ht) with DrawAAText (scaling 4)"
$imgtext DrawAAText 0 200 $str1 $yellow

$imgtext WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgtext "$fname: 3 white rows with DrawText, 1 yellow row with DrawAAText (using text scaling)"

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $lay
poImgUtil DeleteImage $imgtext

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
