source pkgsNeeded.tcl

ui_init "t_filter.tcl"
SetFileTypes

PH "Image filtering commands"

set sw [poSwatchUtil NewSwatch]

set img [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$img GetImageInfo w h a

set imgsave [poImage NewImage $w $h $a]
$imgsave CopyImage $img

set msg "Original image"
ui_addimg $img $msg

set fname "testOut/filterErode1$fInfo(suf)"
set msg   "$fname: Erosion applied 1 times"
P $msg
$img CopyImage $imgsave
$img Erosion
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterErode4$fInfo(suf)"
set msg   "$fname: Erosion applied 4 times"
P $msg
$img CopyImage $imgsave
$img Erosion 4
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterDilatation1$fInfo(suf)"
set msg   "$fname: Dilatation applied 1 times"
P $msg
$img CopyImage $imgsave
$img Dilatation
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterDilatation4$fInfo(suf)"
set msg   "$fname: Dilatation applied 4 times"
P $msg
$img CopyImage $imgsave
$img Dilatation 4
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterRemap$fInfo(suf)"
set msg   "$fname: Remapping color values for RED channel"
P $msg
$img CopyImage $imgsave
set remap [list 1.0 0.8 0.0]
$img RemapChannelValues "RED" $remap
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set xp 10
set yp 10
set fname "testOut/filterMedianIn$fInfo(suf)"
set msg   "$fname: setting green point at $xp,$yp"
P $msg
$img CopyImage $imgsave
poImgUtil SetDrawColorRGB 0 1 0
$img DrawPixel $xp $yp
$img GetPixel $xp $yp tmpcol
P "Pixel at $xp, $yp set to green"
poImgUtil PrintChans $tmpcol DrawColor
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterMedianOut$fInfo(suf)"
set msg   "$fname: Median filtering"
P $msg
$img Median 
$img GetPixel 100 100 tmpcol
P "Pixel at 100, 100 after median filter"
poImgUtil PrintChans $tmpcol DrawColor
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set t 0.2
set fname "testOut/filterThreshold$fInfo(suf)"
set msg "$fname: Thresholding with $t"
P $msg
$img CopyImage $imgsave
set imgthres [poImage NewImage $w $h $a]
$imgthres Blank
$imgthres Threshold $img $t
$imgthres WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgthres $msg

set t 0.4
set fname "testOut/filterCutoff1$fInfo(suf)"
set msg "$fname: Cutoff with $t"
P $msg
set imgCutOff [poImage NewImage $w $h $a]
$imgCutOff CopyImage $imgsave
$imgCutOff CutOff $t
$imgCutOff WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgCutOff $msg

set t1 0.4
set t2 0.6
set fname "testOut/filterCutoff2$fInfo(suf)"
set msg "$fname: Cutoff between $t1 and $t2"
P $msg
set imgCutOff2 [poImage NewImage $w $h $a]
$imgCutOff2 CopyImage $imgsave
$imgCutOff2 CutOff $t1 $t2
$imgCutOff2 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgCutOff2 $msg

set fname "testOut/filterGamma$fInfo(suf)"
set msg   "$fname: Changing gamma to 2 for all channels"
P $msg
$img CopyImage $imgsave
$img ChangeChannelGamma "RED"   2.0
$img ChangeChannelGamma "GREEN" 2.0
$img ChangeChannelGamma "BLUE"  2.0
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterScale$fInfo(suf)"
set msg "$fname: Change scale and offset of channel values"
P $msg
$img CopyImage $imgsave
$img ChangeChannelGamma "RED" 1.0 0.5
$img ChangeChannelGamma "BLUE" 1.0 1.0 0.3
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterHvdiff$fInfo(suf)"
set msg   "$fname: Compute horizontal and vertical differences between pixels"
P $msg
set imghvdiff [poImage NewImage $w $h $a]
$imghvdiff Blank
poImgUtil SetDrawColorRGB 0 0 0.5
$imghvdiff DrawRect 0 0 $w $h
$img CopyImage $imgsave
$imghvdiff ComputeChannelDerivates $img "RED" "RED" "GREEN" false
$imghvdiff WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imghvdiff $msg

set fname "testOut/filterGray1$fInfo(suf)"
set msg "$fname: Generate grayscale image out of RED channel"
P $msg
$img CopyImage $imgsave
$img CopyChannel $img  "RED" "GREEN"
$img CopyChannel $img  "RED" "BLUE"
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/filterGray2$fInfo(suf)"
set msg "$fname: Generate grayscale image out of sensitivity response"
P $msg
set imgadd [poImage NewImage $w $h $a]
$imgadd CopyImage $imgsave
$imgadd ChangeChannelGamma "RED"   1.0 0.30 0.0
$imgadd ChangeChannelGamma "GREEN" 1.0 0.59 0.0
$imgadd ChangeChannelGamma "BLUE"  1.0 0.11 0.0
$img Blank
poImgUtil SetDrawModeRGB "ADD" "REPLACE" "REPLACE"
poImgUtil SetDrawMaskRGB $ON $OFF $OFF
$img CopyRect $imgadd 0 0 $w $h 0 0

$imgadd CopyChannel $imgadd "GREEN" "RED"
$img CopyRect $imgadd 0 0 $w $h 0 0

$imgadd CopyChannel $imgadd "BLUE" "RED"
$img CopyRect $imgadd 0 0 $w $h 0 0

$img CopyChannel $img "RED" "GREEN"
$img CopyChannel $img "RED" "BLUE"

$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $img
poImgUtil DeleteImage $imgadd
poImgUtil DeleteImage $imgsave
poImgUtil DeleteImage $imghvdiff
poImgUtil DeleteImage $imgthres
poImgUtil DeleteImage $imgCutOff
poImgUtil DeleteImage $imgCutOff2

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
