source pkgsNeeded.tcl

ui_init "t_flip.tcl"
SetFileTypes

PH "Image flipping commands"

set img [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$img GetImageInfo w h a

set imgsave [poImage NewImage $w $h $a]
$imgsave CopyImage $img

set msg "Original image"
ui_addimg $img $msg

set fname "testOut/flipHori$fInfo(suf)"
set msg   "$fname: Flipping around horizontal axis"
P $msg
$img FlipHorizontal
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/flipVert$fInfo(suf)"
set msg  "$fname: Flipping around vertical axis"
P $msg
$img CopyImage $imgsave
$img FlipVertical
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/flipDiag$fInfo(suf)"
set msg  "$fname: Flipping diagonally"
P $msg
$img CopyImage $imgsave
# If image is not square, FlipDiagonal does not change pixels
# covered by the flip operation. Fill these pixel with green.
poImgUtil SetDrawColorRGB 0 1 0
$img DrawRect $w 0 $h $h
$img FlipDiagonal
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

$img CopyImage $imgsave
foreach angle [list 90 180 270 -90] {
    set fname "testOut/flipRot_$angle$fInfo(suf)"
    set msg  "$fname: Rotating around $angle degrees"
    P $msg
    set imgrot [$img Rotate90 $angle]
    $imgrot WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $imgrot $msg
    poImgUtil DeleteImage $imgrot
}

poImgUtil DeleteImage $img
poImgUtil DeleteImage $imgsave

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
