# Test covers the following commands:
# 1. CreateChannelNoise
# 2. JuliaSet
# 3. Mandelbrot

source pkgsNeeded.tcl

ui_init "t_fractal.tcl"
SetFileTypes

PH "Draw fractal images"

set imgSize 200

poImgUtil SetFormatRGB $UBYTE $UBYTE $UBYTE

set img [poImage NewImage $imgSize $imgSize]

for { set i 0 } { $i < 256 } { incr i } {
    lappend rmap [expr (255 - $i)]
    lappend gmap [expr (255 - $i)]
    lappend bmap [expr (255 - $i)]
}

set fname "testOut/fractalMandelbrot$fInfo(suf)"
set msg   "$fname: Drawing mandelbrot"
P $msg
$img Blank
$img Mandelbrot 0.002 0.05 5 1000 $rmap $gmap $bmap
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/fractalJuliaset$fInfo(suf)"
set msg   "$fname: Drawing juliaset"
P $msg
$img Blank
$img JuliaSet 0.1234 0.234 0.002 0.05 2 100 $rmap $gmap $bmap
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

set fname "testOut/fractalNoise$fInfo(suf)"
set msg   "$fname: Drawing fractal noise"
P $msg
$img Blank
$img CreateChannelNoise "GREEN" 0 5 3 0.5
$img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img $msg

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
