source pkgsNeeded.tcl

ui_init "t_histo.tcl"
SetFileTypes

PH "Histogram command" 

set img1 [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$img1 GetImageInfo w h
set msg "Original image"
ui_addimg $img1 $msg

poImgUtil SetDrawColorRGB 1 1 1

set outImgLin [poImage NewImage 256 $h]
set outImgLog [poImage NewImage 256 $h]
$outImgLin Blank
$outImgLog Blank

set histoDict    [poImgUtil GetHistogram $img1]
set histoDictLin [poImgUtil ScaleHisto $histoDict $h "lin"]
set histoDictLog [poImgUtil ScaleHisto $histoDict $h "log"]

set fname "testOut/histoLin$fInfo(suf)"
set msg "$fname: Printing linear histogram of RED channel"
P $msg
for { set i 0 } { $i < 256 } { incr i } {
    set val [lindex [dict get $histoDictLin BLUE] $i]
    if { $val != 0 } {
        $outImgLin DrawLine $i 0 $i $val
    }
}
$outImgLin WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $outImgLin $msg

set fname "testOut/histoLog$fInfo(suf)"
set msg "$fname: Printing logarithmic histogram of RED channel"
P $msg
for { set i 0 } { $i < 256 } { incr i } {
    set val [lindex [dict get $histoDictLog BLUE] $i]
    if { $val != 0 } {
        $outImgLog DrawLine $i 0 $i $val
    }
}
$outImgLog WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $outImgLog $msg

set imgSize 256
set img2 [poImage NewImage $imgSize $imgSize]
$img2 Blank
for { set i 0 } { $i < 256 } { incr i } {
    poImgUtil SetDrawColorRGB [expr (double ($i) / 255)] 0 0
    $img2 DrawLine $i 0 $i $i
}
set fname "testOut/histoImgIn$fInfo(suf)"
set msg "$fname: Generating image with linear color distribution"
P $msg
$img2 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $img2 $msg
$img2 GetChannelHistogram "RED" histo2

set outImg [poImage NewImage $imgSize $imgSize]
$outImg Blank
poImgUtil SetDrawColorRGB 1 1 1
set fname "testOut/histoImgOut$fInfo(suf)"
set msg "$fname: Histogram of RED channel of previous image"
P $msg
set sum 0
for { set i 0 } { $i < 256 } { incr i } {
    P "$i: [lindex $histo2 $i]"
    if { [lindex $histo2 $i] != 0 } {
        incr sum [lindex $histo2 $i]
        $outImg DrawLine $i 0 $i [lindex $histo2 $i]
    }
}
P "Sum of pixels: $sum"
set numPixels [expr $imgSize * $imgSize]
if { $sum != $numPixels } {
    PE "Number of histogram entries ($sum) does not match number of pixels ($numPixels)"
}
$outImg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $outImg $msg

poImgUtil DeleteImage $img1 $img2
poImgUtil DeleteImage $outImg $outImgLin $outImgLog

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
