# Expected values as generated with poPhotoUtil::GetImgStats.

# Required time: 0.4460 seconds
set expectedStr(whole) \
"Num pixels    : 262144
Minimum values: (0, 0, 0)
Maximum values: (255, 255, 255)
Mean    values: (81.672, 126.419, 180.264)
StdDev  values: (90.063, 54.861, 47.163)
"

# Required time: 0.0040 seconds
set expectedStr(part) \
"Num pixels    : 1681
Minimum values: (16, 27, 11)
Maximum values: (255, 255, 192)
Mean    values: (82.756, 121.882, 157.273)
StdDev  values: (102.340, 56.074, 53.823)
"

source pkgsNeeded.tcl

ui_init "t_info.tcl"
SetFileTypes

PH "Functions to retrieve image information"

proc PrintAndCheckImgStats { statDict compareString } {
    set minStr [format "(%d, %d, %d)" \
               [dict get $statDict min RED  ] \
               [dict get $statDict min GREEN] \
               [dict get $statDict min BLUE ]]
    set maxStr [format "(%d, %d, %d)" \
               [dict get $statDict max RED  ] \
               [dict get $statDict max GREEN] \
               [dict get $statDict max BLUE ]]
    set medStr [format "(%.3f, %.3f, %.3f)" \
               [dict get $statDict mean RED  ] \
               [dict get $statDict mean GREEN] \
               [dict get $statDict mean BLUE ]]
    set stdStr [format "(%.3f, %.3f, %.3f)" \
               [dict get $statDict std RED  ] \
               [dict get $statDict std GREEN] \
               [dict get $statDict std BLUE ]]
    append msg "Num pixels    : [dict get $statDict num]\n"
    append msg "Minimum values: $minStr\n"
    append msg "Maximum values: $maxStr\n"
    append msg "Mean    values: $medStr\n"
    append msg "StdDev  values: $stdStr\n"
    P $msg
    CheckString $compareString $msg "ImgStats" false
}

set sw [poSwatchUtil NewSwatch]

set poImg [poImage NewImageFromFile "[GetTestInDir]/TeapotSquare.tga"]
$poImg GetImageInfo w h

P "Calculating image characteristics (whole image)"
$sw Reset
set statDict [poImgUtil GetImageStats $poImg]
PSec "Required time" [$sw Lookup]
PrintAndCheckImgStats $statDict $expectedStr(whole)

P "Calculating image characteristics (part of image)"
$sw Reset
# Note: We compare the values calculated with poImgUtil::GetImageStats 
# with the pure Tcl implementation of poPhotoUtil::GetImgStats.
# poImg has the image coordinate origin in the lower-left corner,
# while Tk photos have the origin in the top-left corner.
set y2 [expr $w - 250 - 1]
set y1 [expr $h - 290 - 1]
set statDict [poImgUtil GetImageStats $poImg 30 $y1 70 $y2]
PSec "Required time" [$sw Lookup]
PrintAndCheckImgStats $statDict $expectedStr(part)

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $poImg

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
