# Test covers the following commands:
# 1. Interlace
# 2. Unlace

source pkgsNeeded.tcl

ui_init "t_interlace.tcl"
SetFileTypes

PH "Image commands for interlacing functionality"

set sw [poSwatchUtil NewSwatch]

set xfrm 720
set yfrm 576
set xfld $xfrm
set yfld [expr ($yfrm / 2)]
set asp 1.25

set fld0   [poImage NewImage $xfld $yfld $asp]
set fld1   [poImage NewImage $xfld $yfld $asp]
set frm    [poImage NewImage $xfrm $yfrm $asp]
set frmFld [poImage NewImage $xfrm $yfrm $asp]

poImageState SetTextScale 8
$fld0 Blank
$fld1 Blank
poImgUtil SetDrawColorRGB 1 0 0
$fld0 DrawText 50 50 "Field 0"
poImgUtil SetDrawColorRGB 0 1 0
$fld1 DrawText 50 50 "Field 1"

set fname "testOut/interlace$fInfo(suf)"
set msg   "$fname: Interlacing 2 fields into 1 frame"
P $msg
$frm Interlace $fld0 $fld1 OFF
$frm WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $frm $msg

set fname "testOut/interlaceEvenField$fInfo(suf)"
set msg   "$fname: Unlacing even field from frame (Extract mode)"
P $msg
$fld1 Blank
$fld1 Unlace $frm off
$fld1 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $fld1 $msg

set fname "testOut/interlaceOddField$fInfo(suf)"
set msg   "$fname: Unlacing odd field from frame (Extract mode)"
P $msg
$fld0 Blank
$fld0 Unlace $frm ON
$fld0 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $fld0 $msg

set fname "testOut/interlaceReplicateField$fInfo(suf)"
set msg   "$fname: Unlacing even field from frame (Replicate mode)"
P $msg
$frmFld Blank
$frmFld Unlace $frm off REPLICATE
$frmFld WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $frmFld $msg

set fname "testOut/interlaceInterpolateField$fInfo(suf)"
set msg   "$fname: Unlacing even field from frame (Interpolate mode)"
P $msg
$frmFld Blank
$frmFld Unlace $frm off INTERPOLATE
$frmFld WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $frmFld $msg

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $fld0 $fld1 $frm

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
