source pkgsNeeded.tcl

ui_init "t_io.tcl"
SetFileTypes

PH "Test reading and writing images"

set inFileList [list \
    "[GetTestInDir]/Teapot$fInfo(suf)" \
    "[GetTestInDir]/TeapotAlpha$fInfo(suf)" \
]

foreach inFile $inFileList numChans { 3 4 } {
    set img [poImage NewImageFromFile $inFile]
    set msg "Original ${numChans}-channel image: [file tail $inFile]"
    ui_addimg $img $msg

    poImageState GetFileInfo   $inFile w h
    poImageState GetFileFormat $inFile fmt

    poImageState SetFormat $fmt
    set imgSmaller [poImage NewImage [expr {$w/2}] [expr {$h/2}]]
    set imgLarger  [poImage NewImage [expr {$w*2}] [expr {$h*2}]]
    $imgSmaller Blank
    $imgLarger  Blank

    set fname "testOut/io${numChans}-clip$fInfo(suf)"
    set msg "Read ${numChans}-channel image file into smaller image (clip)"
    P $msg
    $imgSmaller ReadImage $inFile
    $imgSmaller WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $imgSmaller $msg

    set fname "testOut/io${numChans}-fill$fInfo(suf)"
    set msg "Read ${numChans}-channel image file into larger image (fill)"
    P $msg
    poImgUtil SetDrawColorRGB 0.5 0.2 0.1 true
    $imgLarger DrawRect -1 -1 -1 -1
    $imgLarger ReadImage $inFile
    $imgLarger WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $imgLarger $msg

    set fname "testOut/io${numChans}-scale$fInfo(suf)"
    set msg "Read ${numChans}-channel image file into larger image (scale)"
    P $msg
    $imgSmaller ReadImage $inFile "-scale true"
    $imgSmaller WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $imgSmaller $msg

    poImgUtil DeleteImage $img
    poImgUtil DeleteImage $imgSmaller
    poImgUtil DeleteImage $imgLarger
}

# Read 4-channel image and write out only RGB channels.
set img [poImage NewImageFromFile "[GetTestInDir]/TeapotAlpha$fInfo(suf)"]
poImgUtil::SetFormatAll "NONE"

poImgUtil::SetFormatRGB $::UBYTE $::UBYTE $::UBYTE
set fname "testOut/io-rgb$fInfo(suf)"
set msg "Write RGB channels of 4-channel image"
P $msg
$img WriteImage $fname $fInfo(fmt) $fInfo(opt)
set checkImg [poImage NewImageFromFile $fname]
ui_addimg $checkImg $msg

# Write out only red channel. Do this using POI format,
# as Targa does not support a single channel file.
poImgUtil::SetFormatRGB $::UBYTE $::NONE $::NONE
set fname "testOut/io-red.poi"
set msg "Write red channel of 4-channel image"
P $msg
$img WriteImage $fname "POI" $fInfo(opt)

poImageState GetFileFormat $fname fmt
CheckList [list 0 1 0 0 0 0 0 0 0 0 0 0 0] $fmt "Format of image file"

set checkImg [poImage NewImageFromFile $fname]
ui_addimg $checkImg $msg -chanmap [list $RED $RED $RED]

poImgUtil DeleteImage $img
poImgUtil DeleteImage $checkImg

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
