source pkgsNeeded.tcl

ui_init "t_warp.tcl"
SetFileTypes

proc DrawLine { img keyNum  x1 y1 x2 y2  r g b  w h } {
    poImageState PushState
    poImgUtil SetDrawColorRGB $r $g $b
    $img DrawLine [expr int ($x1 * $w)] [expr int ($y1 * $h)] [expr int ($x2 * $w)] [expr int ($y2 * $h)]
    $img DrawText [expr int ($x1 * $w)] [expr int ($y1 * $h)] "S$keyNum"
    $img DrawText [expr int ($x2 * $w)] [expr int ($y2 * $h)] "E$keyNum"
    poImageState PopState
}

PH "Image warping with keypoints"

set xsrc  [list 0.345 0.550 0.515]
set ysrc  [list 0.335 0.280 0.447]
set xdest [list 0.335 0.600 0.500]
set ydest [list 0.410 0.350 0.350]

set srcimg [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$srcimg GetImageInfo w h a
set msg "Original image"
DrawLine $srcimg 1 [lindex $xsrc 0] [lindex $ysrc 0] [lindex $xdest 0] [lindex $ydest 0] 0.0 1.0 0.0 $w $h
DrawLine $srcimg 2 [lindex $xsrc 1] [lindex $ysrc 1] [lindex $xdest 1] [lindex $ydest 1] 0.0 1.0 0.0 $w $h
DrawLine $srcimg 3 [lindex $xsrc 2] [lindex $ysrc 2] [lindex $xdest 2] [lindex $ydest 2] 1.0 0.0 0.0 $w $h
ui_addimg $srcimg $msg

set dstimg [poImage NewImage $w $h $a]

set nkey  2

set fname "testOut/kptwarpLittleLocal$fInfo(suf)"
set msg   "$fname: Keyframe warping (2 keyframes) with little local effect"
P $msg
$dstimg WarpKeypoint $srcimg $nkey $xsrc $ysrc $xdest $ydest 2 0.1
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

set fname "testOut/kptwarpStrongLocal$fInfo(suf)"
set msg   "$fname: Keyframe warping (2 keyframes) with strong local effect"
P $msg
$dstimg WarpKeypoint $srcimg $nkey $xsrc $ysrc $xdest $ydest 2 1.0
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

set fname "testOut/kptwarpGlobal$fInfo(suf)"
set msg   "$fname: Keyframe warping (2 keyframes) with global effect"
P $msg
$dstimg WarpKeypoint $srcimg $nkey $xsrc $ysrc $xdest $ydest 2 0.0
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

set nkey 3

set fname "testOut/kptwarpKeyframe$fInfo(suf)"
set msg   "$fname: Keyframe warping (3 keyframes) with little local effect"
P $msg
$dstimg WarpKeypoint $srcimg $nkey $xsrc $ysrc $xdest $ydest 2 0.1
$dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $dstimg $msg

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
