source pkgsNeeded.tcl

ui_init "t_match.tcl"
SetFileTypes

PH "Pattern matching"

set numImgs 25
RandomInit  0

P "Generating sequence of $numImgs images"

set img1 [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$img1 GetImageInfo w h a

set img2 [poImage NewImage $w $h $a]

set x 0
set y 0

for { set f 1 } { $f <= $numImgs } { incr f 1 } {
    set fname "testOut/matchIn.[format "%03d" $f]$fInfo(suf)"
    $img2 Blank
    $img2 WrapRect $img1 0 0 $w $h  [expr int ($x)] [expr int ($y)]
    P "Writing file $fname with offset ($x, $y)"
    $img2 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    set x [RandomRange 7]
    set y [RandomRange 7]
}
poImgUtil DeleteImage $img1
poImgUtil DeleteImage $img2

set x 120
set y 200
set s_size 2
set d_size 8

P "Trying to find pattern at pixel ($x, $y)"

poImgUtil SetDrawColorRGB 1 0 0

for { set f 1 } { $f < $numImgs } { incr f 1 } {
    set fname1 "testOut/matchIn.[format "%03d" $f]$fInfo(suf)"
    set img1 [poImage NewImageFromFile $fname1]
    set fname2 "testOut/matchIn.[format "%03d" [expr $f +1]]$fInfo(suf)"
    set img2 [poImage NewImageFromFile $fname2]

    P "Img $fname1 and $fname2 ([expr ($x-$s_size)] [expr ($y-$s_size)] \
                                [expr ($x+$s_size)] [expr ($y+$s_size)])"
    $img1 FindChannelPattern $img2 "RED" \
          [expr ($x-$s_size)] [expr ($y-$s_size)] \
          [expr ($x+$s_size)] [expr ($y+$s_size)] \
          [expr ($x-$d_size)] [expr ($y-$d_size)] \
          [expr ($x+$d_size)] [expr ($y+$d_size)] \
          xp yp rp
    set msg "\tCorrelation factor $rp: ($xp $yp)"
    P $msg
    $img1 DrawRect [expr ($xp-1)] [expr ($yp-1)] \
                   [expr ($xp+1)] [expr ($yp+1)]
    set fname "testOut/matchOut.[format "%03d" $f]$fInfo(suf)"
    $img1 WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $img1 $msg
    set x [expr (int ($x + ($xp - ($x-$s_size))))]
    set y [expr (int ($y + ($yp - ($y-$s_size))))]

    poImgUtil DeleteImage $img1
    poImgUtil DeleteImage $img2
}

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
