source pkgsNeeded.tcl

ui_init "t_photo.tcl"
SetFileTypes

PH "Functions to copy between poImages and photo images"

set swatch [poSwatchUtil NewSwatch]

set srcImg [poImage NewImageFromFile "[GetTestInDir]/Colorbar-4chan-compr.tga"]
$srcImg GetImageInfo sw sh
CheckNumber  80 $sw "Source image width"  false
CheckNumber 120 $sh "Source image height" false

if { [poImageState HasPhotoSupport] } {
    set sizeList { 1000 2000 5000 10000 }
    foreach size $sizeList {
        if { $size == 10000 && $tcl_platform(pointerSize) == 4 } {
            P [format "Ignoring (%5d x %5d pixels) on 32-bit systems" $size $size]
            continue
        }
        set phImg1 [image create photo -width $size -height $size]

        set poImg1 [poImgUtil ScaleImage $srcImg $size $size]
        $poImg1 GetImageInfo nw nh
        CheckNumber $size $nw "Scaled image width"  false
        CheckNumber $size $nh "Scaled image height" false

        $swatch Reset
        $poImg1 AsPhoto $phImg1
        set tImg2Photo [$swatch Lookup]
        P [format "poImg -> photo    (%5d x %5d pixels): %.4f seconds" $size $size $tImg2Photo]

        $swatch Reset
        set retVal [catch { poImgUtil AsPhoto $poImg1 } phImg2]
        if { $retVal == 0 } {
            set tImg2Photo [$swatch Lookup]
            P [format "poImg -> img::raw (%5d x %5d pixels): %.4f seconds" $size $size $tImg2Photo]
        } else {
            P [format "poImg -> img::raw (%5d x %5d pixels): %s" $size $size $phImg2]
        }

        $swatch Reset
        set poImg2 [poImage NewImageFromPhoto $phImg1]
        set tPhoto2Img [$swatch Lookup]
        P [format "photo -> poImg    (%5d x %5d pixels): %.4f seconds" $size $size $tPhoto2Img]

        image delete $phImg1
        if { $retVal == 0 } {
            image delete $phImg2
        }

        set diffImg [$poImg1 DifferenceImage $poImg2]

        poImgUtil DeleteImage $poImg1
        poImgUtil DeleteImage $poImg2

        set markImg [$diffImg MarkNonZeroPixels 0 numMarked]
        CheckNumber 0 $numMarked "Differing pixels" false

        poImgUtil DeleteImage $diffImg
        poImgUtil DeleteImage $markImg
    }
} else {
    P "Test skipped, because poImg was compiled without Tk photo support"
}

poSwatchUtil DeleteSwatch $swatch

poImgUtil DeleteImage $srcImg

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
