source pkgsNeeded.tcl

ui_init "t_rotimg.tcl"
SetFileTypes

PH "Rotating images"

set srcimg [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$srcimg GetImageInfo w h a
set dstimg [poImage NewImage $w $h $a]
set msg "Original image"
ui_addimg $srcimg $msg

set numImgs 20
set angle   0.0
for { set i 1 } { $i <= $numImgs } { incr i } {
    set angle [expr $angle + 360.0 / $numImgs]
    set fname "testOut/rotimg.[format "%03d" $i]$fInfo(suf)"
    set msg   "$fname: Rotating around center with $angle degrees."
    P $msg
    poImgUtil Rotate $srcimg $dstimg [poVecUtil DegToRad $angle]
    $dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $dstimg $msg
    $dstimg Blank
}

set angle  0.0
set xCenter 0.5
set yCenter 0.5
for { set i 1 } { $i <= $numImgs } { incr i } {
    set angle [expr $angle + 360.0 / $numImgs]
    set fNum [expr $i + $numImgs*1]
    set fname "testOut/rotimg.[format "%03d" $fNum]$fInfo(suf)"
    set msg   "$fname: Rotating around moving center with $angle degrees."
    P $msg
    poImgUtil Rotate $srcimg $dstimg [poVecUtil DegToRad $angle] $xCenter $yCenter
    $dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $dstimg $msg
    $dstimg Blank
    set xCenter [expr $xCenter + 0.1 * $i / $numImgs]
    set yCenter [expr $yCenter + 0.1 * $i / $numImgs]
}

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
