source pkgsNeeded.tcl

ui_init "t_sgi16.tcl"
SetFileTypes

PH "Drawing pixels with values in the range \[0 .. 65535\]"

P "Caution: Test may last some minutes ..."
P ""

set w 256
set h 256
set n [expr $w * $h]
set mod [expr $w / 10]

poImgUtil SetFormatRGB $FLOAT $FLOAT $FLOAT
set img [poImage NewImage $w $h]
$img GetImageFormat imgfmt 
P "Drawing pixels into image of size $w by $h ..."
poImgUtil PrintChans $imgfmt Format

set sw [poSwatchUtil NewSwatch]

$img Blank
set fname1 "testOut/sgi16.poi"
set fname2 "testOut/sgi16.rgb"

set count 0
for { set y 0 } { $y < $h } { incr y } {
    if { $y % $mod == 0 } {
        PN "." ; 
    }
    for { set x 0 } { $x < $w } { incr x } {
        set color [expr $count / 65535.0]
        poImgUtil SetDrawColorRGB $color $color $color 
        $img DrawPixel $x $y
        incr count
    }
} 
P ""

proc PrintPixel { x y r g b } {
    set rs [expr round(65535.0 * $r)]
    set gs [expr round(65535.0 * $g)]
    set bs [expr round(65535.0 * $b)]
    P "Pixel at $x, $y: $rs $gs $bs"
}

proc CheckPixel { imgName n x y r g b } {
    global scan

    set rs [expr round(65535.0 * $r)]
    set gs [expr round(65535.0 * $g)]
    set bs [expr round(65535.0 * $b)]
    set rscan [expr round(65535.0 * $scan($n,r))]
    set gscan [expr round(65535.0 * $scan($n,g))]
    set bscan [expr round(65535.0 * $scan($n,b))]
    if { $rscan != $rs || $gscan != $gs || $bscan != $bs } {
        P "$imgName: Pixel differs at $x, $y \
          ($rscan, $gscan, $bscan vs. $rs, $gs, $bs)"
    }
}

P "Reading back and storing pixels ..."
set count 0
for { set y 0 } { $y < $h } { incr y } {
    if { $y % $mod == 0 } {
        PN "."
    }
    for { set x 0 } { $x < $w } { incr x } {
        $img GetPixel $x $y colpix 
        set scan($count,r) [lindex $colpix $RED]
        set scan($count,g) [lindex $colpix $GREEN]
        set scan($count,b) [lindex $colpix $BLUE]
        # PrintPixel $x $y $scan($count,r) $scan($count,g) $scan($count,b)
        incr count
    }
}
P ""

P "Writing image in poImage Float format: $fname1"
$img WriteSimple $fname1 "poi"  "-compression rle"
P "Writing image in SGI 16-bit format: $fname2"
$img WriteSimple $fname2 "sgi" "-compression rle"
ui_addimg $img "Pixel values in range \[0 .. 65535\]"

set new1 [poImage NewImageFromFile $fname1]
$new1 GetImageInfo w h a g
$new1 GetImageFormat imgfmt 
P "Reading and checking image in poImage Float format: $fname1 ..."
poImgUtil PrintChans $imgfmt Format

set count 0
for { set y 0 } { $y < $h } { incr y } {
    if { $y % $mod == 0 } {
        PN "."
    }
    for { set x 0 } { $x < $w } { incr x } {
        $new1 GetPixel $x $y colpix
        set r [lindex $colpix $RED]
        set g [lindex $colpix $GREEN]
        set b [lindex $colpix $BLUE]
        CheckPixel $fname1 $count $x $y $r $g $b
        # PrintPixel $x $y $r $g $b
        incr count
    }
}
P ""

set new2 [poImage NewImageFromFile $fname2]
$new2 GetImageInfo w h a g
$new2 GetImageFormat imgfmt 
P "Reading and checking image in SGI 16-bit format: $fname2 ..."
poImgUtil PrintChans $imgfmt Format

set count 0
for { set y 0 } { $y < $h } { incr y } {
    if { $y % $mod == 0 } {
        PN "."
    }
    for { set x 0 } { $x < $w } { incr x } {
        $new2 GetPixel $x $y colpix 
        set r [lindex $colpix $RED]
        set g [lindex $colpix $GREEN]
        set b [lindex $colpix $BLUE]
        CheckPixel $fname2 $count $x $y $r $g $b
        # PrintPixel $x $y $r $g $b
        incr count
    }
}
P ""

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $img
poImgUtil DeleteImage $new1
poImgUtil DeleteImage $new2

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
